/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1110")
public class RedundantParenthesesCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1110";
    private static final String MESSAGE = "Remove these useless parentheses.";

    @Override
    public void visitParenthesisedExpression(ParenthesisedExpressionTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            ParenthesisedExpressionTree parentheses = (ParenthesisedExpressionTree)expression;
            this.context().newIssue(this, parentheses.openParenthesis(), MESSAGE).secondary(parentheses.closeParenthesis(), null);
        }
        super.visitParenthesisedExpression(tree);
    }
}

