/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ReferenceVariableTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4824")
public class UnsetForeachReferenceVariableCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure that the referenced value variable is unset after the loop.";

    @Override
    public void visitForEachStatement(ForEachStatementTree tree) {
        super.visitForEachStatement(tree);
        if (!tree.value().is(Tree.Kind.REFERENCE_VARIABLE)) {
            return;
        }
        ReferenceVariableTree referenceVariable = (ReferenceVariableTree)tree.value();
        Symbol symbol = this.context().symbolTable().getSymbol(referenceVariable.variableExpression());
        if (symbol == null) {
            return;
        }
        boolean usedBeforeUnset = false;
        boolean wasUnset = false;
        for (SyntaxToken usage : symbol.usages()) {
            boolean usageIsOutsideForEach = UnsetForeachReferenceVariableCheck.usageIsOutsideForEach(usage, tree);
            if (usageIsOutsideForEach && !UnsetForeachReferenceVariableCheck.usageIsInUnset(usage)) {
                usedBeforeUnset = true;
                continue;
            }
            if (!usageIsOutsideForEach) continue;
            wasUnset = true;
            break;
        }
        if (!wasUnset && usedBeforeUnset) {
            this.context().newIssue(this, referenceVariable, MESSAGE);
        }
    }

    private static boolean usageIsInUnset(SyntaxToken usage) {
        return usage.getParent().getParent().is(Tree.Kind.UNSET_VARIABLE_STATEMENT);
    }

    private static boolean usageIsOutsideForEach(SyntaxToken usage, ForEachStatementTree tree) {
        SyntaxToken forEachLastToken = ((PHPTree)((Object)tree)).getLastToken();
        return usage.line() > forEachLastToken.line() || usage.line() == forEachLastToken.line() && usage.column() > forEachLastToken.endColumn();
    }
}

