/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S1607")
public class AbortedTestCaseCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Either remove this call or add an explanation about why the test is aborted.";
    private static final Set<String> ABORT_FUNCTIONS = Set.of("marktestskipped", "marktestincomplete");

    @Override
    public void visitFunctionCall(FunctionCallTree fct) {
        if (!this.isPhpUnitTestCase()) {
            return;
        }
        if (AbortedTestCaseCheck.isAbortFunctionWithoutMessage(fct)) {
            this.newIssue(fct, MESSAGE);
        }
        super.visitFunctionCall(fct);
    }

    private static boolean isAbortFunctionWithoutMessage(FunctionCallTree fct) {
        String name = CheckUtils.lowerCaseFunctionName(fct);
        return name != null && ABORT_FUNCTIONS.contains(name) && fct.callArguments().isEmpty();
    }
}

