/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.regex;

import java.util.regex.Matcher;
import org.sonar.check.Rule;
import org.sonar.php.checks.regex.AbstractRegexCheck;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;

@Rule(key="S6393")
public class InvalidDelimiterCheck
extends AbstractRegexCheck {
    private static final String MISSING_OPENING_DELIMITER_MESSAGE = "Add delimiters to this regular expression.";
    private static final String MISSING_CLOSING_DELIMITER_MESSAGE = "Add the missing \"%s\" delimiter to this regular expression.";

    @Override
    protected boolean hasValidDelimiters(LiteralTree tree) {
        String pattern = InvalidDelimiterCheck.trimPattern(tree);
        if (pattern.length() >= 2) {
            Matcher m = DELIMITER_PATTERN.matcher(pattern);
            if (!m.find()) {
                this.newIssue(tree, MISSING_OPENING_DELIMITER_MESSAGE);
            } else if (!InvalidDelimiterCheck.containsEndDelimiter(pattern.substring(1), Character.valueOf(m.group().charAt(0)))) {
                this.newIssue(tree, String.format(MISSING_CLOSING_DELIMITER_MESSAGE, Character.valueOf(m.group().charAt(0))));
            }
        }
        return false;
    }

    @Override
    public void checkRegex(RegexParseResult regexParseResult, FunctionCallTree regexFunctionCall) {
    }
}

