/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.regex;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.regex.AbstractRegexCheck;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.SyntaxError;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

@Rule(key="S5856")
public class InvalidRegexCheck
extends AbstractRegexCheck {
    private static final String MESSAGE_FORMAT = "Fix the syntax error%s inside this regex.";

    @Override
    public void checkRegex(RegexParseResult regexParseResult, FunctionCallTree regexFunctionCall) {
        List<SyntaxError> syntaxErrors = regexParseResult.getSyntaxErrors();
        if (!syntaxErrors.isEmpty()) {
            this.reportSyntaxErrors(syntaxErrors);
        }
    }

    private void reportSyntaxErrors(List<SyntaxError> syntaxErrors) {
        RegexSyntaxElement tree = syntaxErrors.get(0).getOffendingSyntaxElement();
        List<RegexIssueLocation> secondaries = syntaxErrors.stream().map(error -> new RegexIssueLocation(error.getOffendingSyntaxElement(), error.getMessage())).toList();
        String msg = String.format(MESSAGE_FORMAT, secondaries.size() > 1 ? "s" : "");
        this.newIssue(tree, msg, null, secondaries);
    }
}

