/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.php.checks.CheckBundle;
import org.sonar.php.checks.CheckBundlePart;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class ClearTextProtocolsCheckPart
extends PHPVisitorCheck
implements CheckBundlePart {
    private static final List<String> UNSAFE_PROTOCOLS = Arrays.asList("http://", "ftp://", "telnet://");
    private static final Map<String, String> ALTERNATIVE_PROTOCOLS = new HashMap<String, String>();
    private static final String LOOPBACK_IPV4 = "^127(?:\\.[0-9]+){0,2}\\.[0-9]+$";
    private static final String LOOPBACK_IPV6 = "^(?:0*:){0,7}?:?0*1$";
    private static final Pattern LOOPBACK_IP;
    private static final QualifiedName SWIFTMAILER_QN;
    private static final QualifiedName PHPMAILER_QN;
    private static final Set<String> EXCEPTION_FULL_HOSTS;
    private static final Set<String> EXCEPTION_TOP_HOSTS;
    private static final String MESSAGE_PROTOCOL = "Using %s protocol is insecure. Use %s instead";
    private static final String MESSAGE_FTP = "Using ftp_connect() is insecure. Use ftp_ssl_connect() instead";
    private static final String MESSAGE_MAIL = "Mail transport without encryption is insecure. Specify an encryption";
    private boolean inLaravelConfigFile;
    private final Map<ExpressionTree, MailConfig> mailConfigs = new HashMap<ExpressionTree, MailConfig>();
    private CheckBundle bundle;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.inLaravelConfigFile = this.context().getPhpFile().uri().getPath().endsWith("config/mail.php");
        super.visitCompilationUnit(tree);
        this.mailConfigs.forEach((definition, config) -> {
            if (config.isClearText()) {
                this.context().newIssue(this.getBundle(), config.encryption != null ? config.encryption : definition, MESSAGE_MAIL);
            }
        });
        this.mailConfigs.clear();
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        if (!tree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            return;
        }
        String value = CheckUtils.trimQuotes(tree).trim().toLowerCase(Locale.ROOT);
        if (!value.matches("\\S+")) {
            return;
        }
        if (ClearTextProtocolsCheckPart.startsWithUnsafeProtocol(value) && !ClearTextProtocolsCheckPart.isExceptionUrl(value, tree)) {
            ALTERNATIVE_PROTOCOLS.keySet().stream().filter(value::startsWith).findFirst().ifPresent(usedProtocol -> this.context().newIssue(this.getBundle(), tree, String.format(MESSAGE_PROTOCOL, usedProtocol, ALTERNATIVE_PROTOCOLS.get(usedProtocol))));
        }
    }

    private static boolean isExceptionUrl(String value, LiteralTree tree) {
        if (UNSAFE_PROTOCOLS.contains(value)) {
            return !tree.getParent().is(Tree.Kind.CONCATENATION);
        }
        return ClearTextProtocolsCheckPart.hasExceptionHost(value);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if ("ftp_connect".equalsIgnoreCase(CheckUtils.getFunctionName(tree))) {
            this.context().newIssue(this.getBundle(), tree.callee(), MESSAGE_FTP);
        }
        super.visitFunctionCall(tree);
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        ExpressionTree returnExpression;
        if (this.inLaravelConfigFile && (returnExpression = tree.expression()) != null && ClearTextProtocolsCheckPart.isArray(returnExpression)) {
            this.checkLaravelMailConfig((ArrayInitializerTree)returnExpression);
        }
        super.visitReturnStatement(tree);
    }

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        if (this.isInstantiationOf(tree, SWIFTMAILER_QN)) {
            this.mailConfigs.putIfAbsent(tree, SwiftMailConfig.of(tree));
        } else if (this.isInstantiationOf(tree, PHPMAILER_QN)) {
            this.mailConfigs.putIfAbsent(tree, new PhpMailerMailConfig());
        }
        super.visitNewExpression(tree);
    }

    private boolean isInstantiationOf(NewExpressionTree tree, QualifiedName name) {
        ExpressionTree expression = tree.expression();
        if (!expression.is(Tree.Kind.FUNCTION_CALL) || !((FunctionCallTree)expression).callee().is(Tree.Kind.NAMESPACE_NAME)) {
            return false;
        }
        return name.equals(this.getFullyQualifiedName((NamespaceNameTree)((FunctionCallTree)expression).callee()));
    }

    @Override
    public void visitMemberAccess(MemberAccessTree tree) {
        super.visitMemberAccess(tree);
        NewExpressionTree receiver = ClearTextProtocolsCheckPart.getOriginalNewExpression(tree.object());
        if (receiver == null || !this.mailConfigs.containsKey(receiver)) {
            return;
        }
        Tree parent = tree.getParent();
        if (parent.is(Tree.Kind.FUNCTION_CALL)) {
            this.mailConfigs.get(receiver).handleMethodCall((FunctionCallTree)parent);
        } else if (parent.is(Tree.Kind.ASSIGNMENT) && ((AssignmentExpressionTree)parent).variable() == tree) {
            this.mailConfigs.get(receiver).handleFieldAssignment((AssignmentExpressionTree)parent);
        }
    }

    private static NewExpressionTree getOriginalNewExpression(ExpressionTree tree) {
        ExpressionTree assignedValue = CheckUtils.skipParenthesis(CheckUtils.assignedValue(tree));
        if (assignedValue.is(Tree.Kind.NEW_EXPRESSION)) {
            return (NewExpressionTree)assignedValue;
        }
        if (tree.is(Tree.Kind.FUNCTION_CALL) && ((FunctionCallTree)tree).callee().is(Tree.Kind.OBJECT_MEMBER_ACCESS)) {
            return ClearTextProtocolsCheckPart.getOriginalNewExpression(((MemberAccessTree)((FunctionCallTree)tree).callee()).object());
        }
        return null;
    }

    private void checkLaravelMailConfig(ArrayInitializerTree tree) {
        ArrayInitializerTree mailerConfigs = tree.arrayPairs().stream().filter(p -> p.key() != null).filter(p -> p.key().is(Tree.Kind.REGULAR_STRING_LITERAL)).filter(p -> "mailers".equals(CheckUtils.trimQuotes((LiteralTree)p.key()))).filter(p -> ClearTextProtocolsCheckPart.isArray(p.value())).map(p -> (ArrayInitializerTree)p.value()).findFirst().orElse(null);
        if (mailerConfigs == null) {
            return;
        }
        for (ArrayPairTree pairTree : mailerConfigs.arrayPairs()) {
            LaravelMailConfig config;
            if (pairTree.key() == null || !ClearTextProtocolsCheckPart.isArray(pairTree.value()) || !(config = LaravelMailConfig.of((ArrayInitializerTree)pairTree.value())).isSmtp()) continue;
            this.mailConfigs.put(pairTree.key(), config);
        }
    }

    @Override
    public void setBundle(CheckBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public CheckBundle getBundle() {
        return this.bundle;
    }

    private static boolean startsWithUnsafeProtocol(String value) {
        return UNSAFE_PROTOCOLS.stream().anyMatch(value::startsWith);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasExceptionHost(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String host = uri.getHost();
        if (host == null) {
            host = uri.getAuthority();
        }
        if (host == null) return true;
        if ("localhost".equals(host)) return true;
        if (LOOPBACK_IP.matcher(host).matches()) return true;
        if (EXCEPTION_FULL_HOSTS.stream().anyMatch(host::equals)) return true;
        if (!EXCEPTION_TOP_HOSTS.stream().anyMatch(host::matches)) return false;
        return true;
    }

    private static boolean isArray(Tree tree) {
        return tree.is(Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.ARRAY_INITIALIZER_FUNCTION);
    }

    static {
        ALTERNATIVE_PROTOCOLS.put("http", "https");
        ALTERNATIVE_PROTOCOLS.put("ftp", "sftp, scp or ftps");
        ALTERNATIVE_PROTOCOLS.put("telnet", "ssh");
        LOOPBACK_IP = Pattern.compile("^127(?:\\.[0-9]+){0,2}\\.[0-9]+$|^(?:0*:){0,7}?:?0*1$");
        SWIFTMAILER_QN = QualifiedName.qualifiedName("Swift_SmtpTransport");
        PHPMAILER_QN = QualifiedName.qualifiedName("PHPMailer\\PHPMailer\\PHPMailer");
        EXCEPTION_FULL_HOSTS = new HashSet<String>(Arrays.asList("www.w3.org", "xml.apache.org", "schemas.xmlsoap.org", "schemas.openxmlformats.org", "rdfs.org", "purl.org", "xmlns.com", "schemas.google.com", "a9.com", "ns.adobe.com", "ltsc.ieee.org", "docbook.org", "graphml.graphdrawing.org", "json-schema.org"));
        EXCEPTION_TOP_HOSTS = new HashSet<String>(Arrays.asList("(.*\\.)?example\\.com$", "(.*\\.)?example\\.org$", "(.*\\.)?test\\.com$"));
    }

    private static class SwiftMailConfig
    extends MailConfig {
        public SwiftMailConfig(@Nullable ExpressionTree host, @Nullable ExpressionTree encryption) {
            super(host, encryption);
        }

        private static SwiftMailConfig of(NewExpressionTree tree) {
            FunctionCallTree initCall = (FunctionCallTree)tree.expression();
            return new SwiftMailConfig(CheckUtils.argument(initCall, "host", 0).map(CallArgumentTree::value).orElse(null), CheckUtils.argument(initCall, "encryption", 2).map(CallArgumentTree::value).orElse(null));
        }

        @Override
        protected void handleMethodCall(FunctionCallTree tree) {
            if (tree.callArguments().size() != 1) {
                return;
            }
            Tree memberExpression = ((MemberAccessTree)tree.callee()).member();
            if (!memberExpression.is(Tree.Kind.NAME_IDENTIFIER)) {
                this.hasUnknownState = true;
                return;
            }
            String methodName = ((NameIdentifierTree)memberExpression).text();
            ExpressionTree argument = ((CallArgumentTree)tree.callArguments().get(0)).value();
            if ("setEncryption".equalsIgnoreCase(methodName)) {
                this.encryption = argument;
            } else if ("setHost".equalsIgnoreCase(methodName)) {
                this.host = argument;
            }
        }
    }

    private static class PhpMailerMailConfig
    extends MailConfig {
        private PhpMailerMailConfig() {
            super(null, null);
        }

        @Override
        protected void handleFieldAssignment(AssignmentExpressionTree tree) {
            Tree memberExpression = ((MemberAccessTree)tree.variable()).member();
            if (!memberExpression.is(Tree.Kind.NAME_IDENTIFIER)) {
                this.hasUnknownState = true;
                return;
            }
            String fieldName = ((NameIdentifierTree)memberExpression).text();
            ExpressionTree value = tree.value();
            if ("SMTPSecure".equals(fieldName)) {
                this.encryption = value;
            } else if ("Host".equals(fieldName)) {
                this.host = value;
            }
        }
    }

    private static class MailConfig {
        protected ExpressionTree host;
        protected ExpressionTree encryption;
        protected boolean hasUnknownState = false;

        protected MailConfig(@Nullable ExpressionTree host, @Nullable ExpressionTree encryption) {
            this.host = host;
            this.encryption = encryption;
        }

        protected boolean isClearText() {
            return !this.hasUnknownState && this.hasInsecureEncryption() && this.hasInsecureHost();
        }

        private boolean hasInsecureHost() {
            if (this.host == null) {
                return false;
            }
            ExpressionTree hostValueTree = CheckUtils.assignedValue(this.host);
            if (!hostValueTree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
                return false;
            }
            String hostValue = CheckUtils.trimQuotes((LiteralTree)hostValueTree).toLowerCase(Locale.ROOT);
            return !"localhost".equals(hostValue) && !hostValue.startsWith("ssl://") && !hostValue.startsWith("tls://") && !LOOPBACK_IP.matcher(hostValue).matches();
        }

        private boolean hasInsecureEncryption() {
            if (this.encryption == null) {
                return true;
            }
            ExpressionTree encryptionValueTree = CheckUtils.assignedValue(this.encryption);
            if (encryptionValueTree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
                String encryptionValue = CheckUtils.trimQuotes((LiteralTree)encryptionValueTree).toLowerCase(Locale.ROOT);
                return !"ssl".equals(encryptionValue) && !"tls".equals(encryptionValue);
            }
            return encryptionValueTree.is(Tree.Kind.NULL_LITERAL);
        }

        protected void handleMethodCall(FunctionCallTree tree) {
        }

        protected void handleFieldAssignment(AssignmentExpressionTree tree) {
        }
    }

    private static class LaravelMailConfig
    extends MailConfig {
        private final ExpressionTree transport;

        public LaravelMailConfig(@Nullable ExpressionTree transport, @Nullable ExpressionTree host, @Nullable ExpressionTree encryption) {
            super(host, encryption);
            this.transport = transport;
        }

        private static LaravelMailConfig of(ArrayInitializerTree tree) {
            ExpressionTree transport = null;
            ExpressionTree host = null;
            ExpressionTree encryption = null;
            for (ArrayPairTree pairTree : tree.arrayPairs()) {
                String key;
                if (pairTree.key() == null || !pairTree.key().is(Tree.Kind.REGULAR_STRING_LITERAL)) continue;
                switch (key = CheckUtils.trimQuotes((LiteralTree)pairTree.key())) {
                    case "transport": {
                        transport = pairTree.value();
                        break;
                    }
                    case "host": {
                        host = pairTree.value();
                        break;
                    }
                    case "encryption": {
                        encryption = pairTree.value();
                        break;
                    }
                }
            }
            return new LaravelMailConfig(transport, host, encryption);
        }

        private boolean isSmtp() {
            return this.transport != null && this.transport.is(Tree.Kind.REGULAR_STRING_LITERAL) && "smtp".equals(CheckUtils.trimQuotes((LiteralTree)this.transport));
        }
    }
}

