/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2255")
public class CookieSensitiveDataCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure that this cookie is written safely.";
    private static final List<String> SET_COOKIE_FUNCTIONS = Arrays.asList("setcookie", "setrawcookie");
    private static final int VALUE_PARAMETER_INDEX = 1;
    private static final String VALUE_PARAMETER_NAME = "value";

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if (SET_COOKIE_FUNCTIONS.contains(functionName) && CookieSensitiveDataCheck.hasCookieValue(tree)) {
            this.context().newIssue(this, tree.callee(), MESSAGE);
        }
        super.visitFunctionCall(tree);
    }

    private static boolean hasCookieValue(FunctionCallTree tree) {
        Optional<CallArgumentTree> argument = CheckUtils.argument(tree, VALUE_PARAMETER_NAME, 1);
        return argument.isPresent() && !CheckUtils.isNullOrEmptyString(argument.get().value());
    }
}

