/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.symbols;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.Symbol;
import org.sonar.php.symbols.Trilean;
import org.sonar.plugins.php.api.symbols.QualifiedName;

public abstract class AbstractClassSymbol
implements ClassSymbol {
    private Set<ClassSymbol> allSuperTypes;

    @Override
    public Trilean isOrSubClassOf(QualifiedName qualifiedName) {
        HashSet<AbstractClassSymbol> visitedClasses = new HashSet<AbstractClassSymbol>();
        ClassSymbol superClass = this;
        while (superClass != null) {
            if (qualifiedName.equals(superClass.qualifiedName())) {
                return Trilean.TRUE;
            }
            if (superClass.isUnknownSymbol()) {
                return Trilean.UNKNOWN;
            }
            if (!visitedClasses.add((AbstractClassSymbol)superClass)) {
                return Trilean.FALSE;
            }
            superClass = superClass.superClass().orElse(null);
        }
        return Trilean.FALSE;
    }

    @Override
    public Trilean isSubTypeOf(QualifiedName ... typeNames) {
        for (QualifiedName typeName : typeNames) {
            if (!this.allSuperTypes().stream().anyMatch(s -> s.qualifiedName().equals(typeName))) continue;
            return Trilean.TRUE;
        }
        if (this.allSuperTypes().stream().anyMatch(Symbol::isUnknownSymbol)) {
            return Trilean.UNKNOWN;
        }
        return Trilean.FALSE;
    }

    @Override
    public Set<ClassSymbol> allSuperTypes() {
        if (this.allSuperTypes == null) {
            this.allSuperTypes = new HashSet<ClassSymbol>();
            ArrayDeque<AbstractClassSymbol> workList = new ArrayDeque<AbstractClassSymbol>();
            workList.push(this);
            while (!workList.isEmpty()) {
                ClassSymbol symbol = (ClassSymbol)workList.pop();
                if (!this.allSuperTypes.add(symbol)) continue;
                symbol.superClass().ifPresent(workList::push);
                symbol.implementedInterfaces().forEach(workList::push);
            }
        }
        return this.allSuperTypes;
    }
}

