/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import java.util.Iterator;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ComputedVariableTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ComputedVariableTreeImpl
extends PHPTree
implements ComputedVariableTree {
    private static final Tree.Kind KIND = Tree.Kind.COMPUTED_VARIABLE_NAME;
    private final InternalSyntaxToken openCurly;
    private final ExpressionTree expression;
    private final InternalSyntaxToken closeCurly;

    public ComputedVariableTreeImpl(InternalSyntaxToken openCurly, ExpressionTree expression, InternalSyntaxToken closeCurly) {
        this.openCurly = openCurly;
        this.expression = expression;
        this.closeCurly = closeCurly;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurly;
    }

    @Override
    public ExpressionTree variableExpression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurly;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.iteratorOf(this.openCurly, this.expression, this.closeCurly);
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitComputedVariable(this);
    }
}

