/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit;

import java.io.File;
import java.util.List;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.php.reports.AbstractReportImporter;
import org.sonar.plugins.php.reports.ExternalReportWildcardProvider;
import org.sonar.plugins.php.warning.AnalysisWarningsWrapper;

public abstract class PhpUnitReportImporter
extends AbstractReportImporter {
    private static final String UNRESOLVED_INPUT_FILE_MESSAGE_FORMAT = "Failed to resolve %s file path(s) in %s %s report. Nothing is imported related to file(s): %s";

    protected PhpUnitReportImporter(AnalysisWarningsWrapper analysisWarningsWrapper) {
        super(analysisWarningsWrapper);
    }

    @Override
    public final void execute(SensorContext context) {
        super.execute(context);
        if (this.getReportFiles(context).isEmpty()) {
            this.logger().info("No {} reports provided (see '{}' property)", (Object)this.reportName(), (Object)this.reportPathKey());
        }
    }

    @Override
    public String getUnresolvedInputFileMessageFormat() {
        return UNRESOLVED_INPUT_FILE_MESSAGE_FORMAT;
    }

    @Override
    public String getFileReadErrorMessage(Exception e, File reportPath) {
        return String.format("An error occurred when reading report file '%s', nothing will be imported from this report. %s: %s", reportPath, e.getClass().getSimpleName(), e.getMessage());
    }

    @Override
    public List<File> getReportFiles(SensorContext context) {
        return ExternalReportWildcardProvider.getReportFiles(context, this.reportPathKey());
    }

    protected void createWarning(String message, File file) {
        String warning = String.format(message, file.getAbsolutePath());
        this.logger().warn(warning);
        this.analysisWarningsWrapper.addWarning(warning);
    }
}

