/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.google;

import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.google.GeminiAiClient;
import com.teamscale.core.ai.google.GoogleAiEngineProviderOptionBase;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="ai-engine.geminiai", name="Google Gemini AI Provider", visibilityFeatureToggle=EFeatureToggle.AI_SUPPORT, type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AI, orderingHint=3000)
@IndexValueClass(containedInBackup=true)
public class GeminiAiEngineProviderOption
extends GoogleAiEngineProviderOptionBase {
    private static final long serialVersionUID = 1L;

    @Override
    public String getInternalName() {
        return "geminiai." + this.model;
    }

    @Override
    public String getDisplayName() {
        return "Google Gemini AI (" + this.model + ")";
    }

    @Override
    protected ILlmCompleter createCompleterWithIOException(@Nullable BiConsumer<String, Long> usageReporter) throws IOException {
        return new GeminiAiClient(this.model, this.project, this.location, this.serviceAccount, this.temperature, usageReporter);
    }
}

