/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.analysis.IndexBasedAnalysisConstants;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ConfigurationTemplateManager;
import com.teamscale.core.analysis.configuration.IAnalysisContributor;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.factory.IFactory;

public abstract class AnalysisContributorBase
implements IAnalysisContributor {
    protected GlobalStorageSystem globalStorageSystem;
    private final PairList<IFactory<AnalysisConfigurationBase, ProjectConfigurationException>, IAnalysisContributor.IConfigurationDecider> configurations = new PairList();

    protected void registerContributor(IFactory<AnalysisConfigurationBase, ProjectConfigurationException> contributorFactory) {
        this.registerContributor(contributorFactory, (Set<ELanguage> languages, Set<EAnalysisTool> tools) -> true);
    }

    protected void registerContributor(IFactory<AnalysisConfigurationBase, ProjectConfigurationException> contributorFactory, EAnalysisTool tool) {
        this.registerContributor(contributorFactory, (Set<ELanguage> languages, Set<EAnalysisTool> tools) -> tools.contains((Object)tool));
    }

    protected void registerContributor(IFactory<AnalysisConfigurationBase, ProjectConfigurationException> contributorFactory, ELanguage ... languages) {
        this.registerContributor(contributorFactory, (Set<ELanguage> templateLanguages, Set<EAnalysisTool> tools) -> !CollectionUtils.intersectionSet((Collection)templateLanguages, (Collection[])new Collection[]{CollectionUtils.asHashSet((Object[])languages)}).isEmpty());
    }

    protected void registerContributor(IFactory<AnalysisConfigurationBase, ProjectConfigurationException> contributorFactory, Set<ELanguage> languages) {
        this.registerContributor(contributorFactory, (Set<ELanguage> templateLanguages, Set<EAnalysisTool> tools) -> !CollectionUtils.intersectionSet((Collection)templateLanguages, (Collection[])new Collection[]{languages}).isEmpty());
    }

    protected void registerCodeOnlyContributor(IFactory<AnalysisConfigurationBase, ProjectConfigurationException> contributorFactory) {
        this.registerContributor(contributorFactory, (Set<ELanguage> languages, Set<EAnalysisTool> tools) -> IndexBasedAnalysisConstants.containsCodeLanguage(languages));
    }

    @Override
    public List<AnalysisConfigurationBase> createAllConfigurations(GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        if (this.globalStorageSystem == null) {
            this.globalStorageSystem = globalStorageSystem;
        }
        ArrayList<AnalysisConfigurationBase> createdConfigurations = new ArrayList<AnalysisConfigurationBase>();
        for (Pair configuration : this.configurations) {
            createdConfigurations.add((AnalysisConfigurationBase)((IFactory)configuration.getFirst()).create());
        }
        return createdConfigurations;
    }

    private void registerContributor(IFactory<AnalysisConfigurationBase, ProjectConfigurationException> contributorFactory, IAnalysisContributor.IConfigurationDecider decider) {
        this.configurations.add(contributorFactory, (Object)decider);
    }

    @Override
    public void contributeToTemplates(ConfigurationTemplateManager templateManager, CodeScopeAware<Set<ELanguage>> languagesPerCodeScope, CodeScopeAware<Set<EAnalysisTool>> toolsPerCodeScope, GlobalStorageSystem storageSystem) throws ProjectConfigurationException {
        HashSet<String> createdConfigurations = new HashSet<String>();
        for (int i = 0; i < this.configurations.size(); ++i) {
            IAnalysisContributor.IConfigurationDecider decider = (IAnalysisContributor.IConfigurationDecider)this.configurations.getSecond(i);
            if (!decider.shouldBeIncluded(languagesPerCodeScope.getValues().stream().flatMap(Collection::stream).collect(Collectors.toSet()), toolsPerCodeScope.getValues().stream().flatMap(Collection::stream).collect(Collectors.toSet()))) continue;
            this.globalStorageSystem = storageSystem;
            AnalysisConfigurationBase configuration = (AnalysisConfigurationBase)((IFactory)this.configurations.getFirst(i)).create();
            AnalysisContributorBase.checkConfigurationsAreUnique(configuration, createdConfigurations);
            for (ConfigurationTemplate configurationTemplate : templateManager.getConfigurationTemplates()) {
                configuration.registerQualityIndicators(configurationTemplate, languagesPerCodeScope.getValue(configurationTemplate.getCodeScope()), toolsPerCodeScope.getValue(configurationTemplate.getCodeScope()));
            }
        }
    }

    private static void checkConfigurationsAreUnique(AnalysisConfigurationBase configuration, Set<String> createdConfigurations) {
        String configName = configuration.getClass().getName();
        boolean configAdded = createdConfigurations.add(configName);
        CCSMAssert.isTrue((boolean)configAdded, (String)("Registering the same analysis configuration multiple times is not possible: " + configName));
    }
}

