/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ConfigurationTemplateManager;
import com.teamscale.core.analysis.configuration.IAnalysisContributor;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.spi.TeamscaleServiceLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class ConfigRegistry {
    private static ConfigRegistry instance;
    private final UnmodifiableList<IAnalysisContributor> analysisContributors = CollectionUtils.asUnmodifiable(ConfigRegistry.discoverAnalysisContributors());
    private final UnmodifiableMap<String, Class<? extends ConnectorDescriptorBase>> connectors = CollectionUtils.asUnmodifiable(ConfigRegistry.discoverConnectors());

    private ConfigRegistry() {
    }

    private static Map<String, Class<? extends ConnectorDescriptorBase>> discoverConnectors() {
        HashMap<String, Class<? extends ConnectorDescriptorBase>> connectors = new HashMap<String, Class<? extends ConnectorDescriptorBase>>();
        List connectorDescriptorClasses = ClassIndexUtils.getAnnotated(ConnectorDescriptor.class);
        for (Class clazz : connectorDescriptorClasses) {
            if (ConnectorDescriptorBase.class.isAssignableFrom(clazz)) {
                Class<ConnectorDescriptorBase> connectorDescriptorClass = clazz.asSubclass(ConnectorDescriptorBase.class);
                ConnectorDescriptor connectorDescriptorAnnotation = connectorDescriptorClass.getAnnotation(ConnectorDescriptor.class);
                if (connectorDescriptorAnnotation.enabledByFeatureToggle() != EFeatureToggle.NONE && !connectorDescriptorAnnotation.enabledByFeatureToggle().isEnabled() || connectorDescriptorAnnotation.disabledByFeatureToggle() != EFeatureToggle.NONE && connectorDescriptorAnnotation.disabledByFeatureToggle().isEnabled()) continue;
                ConnectorDescriptorBase connector = ConfigRegistry.createConnectorDescriptor(connectorDescriptorClass.asSubclass(ConnectorDescriptorBase.class));
                CCSMAssert.isNotNull((Object)connector);
                String name = connector.getName();
                CCSMAssert.isFalse((boolean)connectors.containsKey(name), (String)("Duplicate connector with name " + name));
                connectors.put(name, connectorDescriptorClass);
                continue;
            }
            throw new AssertionError((Object)("Expecting " + String.valueOf(clazz) + " to implement " + String.valueOf(ConnectorDescriptorBase.class)));
        }
        return connectors;
    }

    private static List<IAnalysisContributor> discoverAnalysisContributors() {
        return TeamscaleServiceLoader.loadAll(IAnalysisContributor.class).sorted(Comparator.comparingInt(IAnalysisContributor::orderingHint)).toList();
    }

    public static synchronized ConfigRegistry getInstance() {
        if (instance == null) {
            instance = new ConfigRegistry();
        }
        return instance;
    }

    private static ConnectorDescriptorBase createConnectorDescriptor(Class<? extends ConnectorDescriptorBase> descriptorClass) {
        try {
            Constructor<? extends ConnectorDescriptorBase> constructor = descriptorClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            CCSMAssert.fail((String)("Construction of connector descriptor failed: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public ConnectorDescriptorBase createConnectorDescriptor(String name) {
        Class connectorClass = (Class)this.connectors.get((Object)name);
        if (connectorClass == null) {
            return null;
        }
        return ConfigRegistry.createConnectorDescriptor(connectorClass);
    }

    public synchronized ConfigurationTemplate createConfigurationTemplate(Set<ELanguage> languages, Set<EAnalysisTool> tools, GlobalStorageSystem storageSystem) throws ProjectConfigurationException {
        ConfigurationTemplateManager templateManager = this.initializeConfigurationTemplateManager(CodeScopeAware.defaultCodeScopeWithValue(languages), CodeScopeAware.defaultCodeScopeWithValue(tools), List.of(CodeScopeAware.DEFAULT_CODE_SCOPE), storageSystem);
        return templateManager.getConfigurationTemplate(CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public synchronized ConfigurationTemplateManager initializeConfigurationTemplateManager(CodeScopeAware<Set<ELanguage>> languages, CodeScopeAware<Set<EAnalysisTool>> tools, Collection<CodeScopeName> codeScopeNames, GlobalStorageSystem storageSystem) throws ProjectConfigurationException {
        ConfigurationTemplateManager templateManager = new ConfigurationTemplateManager();
        for (CodeScopeName codeScopeName : codeScopeNames) {
            ConfigurationTemplate configurationTemplate = new ConfigurationTemplate(codeScopeName, templateManager, languages.getValue(codeScopeName));
            templateManager.setConfigurationTemplate(codeScopeName, configurationTemplate);
        }
        for (IAnalysisContributor contributor : this.analysisContributors) {
            contributor.contributeToTemplates(templateManager, languages, tools, storageSystem);
        }
        for (ConfigurationTemplate configurationTemplate : templateManager.getConfigurationTemplates()) {
            configurationTemplate.removeEmptyGroups();
        }
        return templateManager;
    }

    public List<ConnectorDescriptorBase> createAllDescriptors() {
        ArrayList<ConnectorDescriptorBase> result = new ArrayList<ConnectorDescriptorBase>();
        for (Class descriptorClass : this.connectors.values()) {
            result.add(ConfigRegistry.createConnectorDescriptor(descriptorClass));
        }
        Collections.sort(result);
        return result;
    }
}

