/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import java.lang.reflect.Field;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;

public abstract class PairListOptionDescriptorBase<T>
extends ConfigOptionDescriptorBase {
    private static final long serialVersionUID = 1L;
    private static final String PART_SEPARATOR = "->";
    private static final String PART_SEPARATOR_WITH_SPACE = " -> ";

    protected PairListOptionDescriptorBase(ConfigExposed annotation, Field field, Class<T> genericType) {
        super(annotation, field, genericType.getSimpleName());
    }

    protected PairListOptionDescriptorBase(String name, String description) {
        super(name, description);
    }

    @Override
    protected Object parseValue(String optionValue) throws ProjectConfigurationException {
        return PairListOptionDescriptorBase.parseFromString(optionValue, this::parseSecond);
    }

    protected static <T> PairList<String, T> parseFromString(String optionValue, FunctionWithException<String, T, ProjectConfigurationException> secondValueParser) throws ProjectConfigurationException {
        PairList result = new PairList();
        if (!StringUtils.isEmpty((String)optionValue)) {
            for (String part : optionValue.split("[,\\n]")) {
                if (!part.contains(PART_SEPARATOR)) {
                    throw new ProjectConfigurationException("Malformed pair list! Missing '->' in " + part + ".");
                }
                String[] keyValue = part.split(PART_SEPARATOR, 2);
                result.add((Object)keyValue[0].trim(), secondValueParser.apply((Object)keyValue[1].trim()));
            }
        }
        return result;
    }

    @Override
    public String retrieveValueAsString(CodeScopeName codeScopeName) {
        return PairListOptionDescriptorBase.getValueAsString(this.retrieveValue(codeScopeName));
    }

    @Override
    public String getDefaultValueAsString() {
        if (this.defaultValue == null) {
            return null;
        }
        return PairListOptionDescriptorBase.getValueAsString(this.defaultValue);
    }

    public static String getValueAsString(Object value) {
        StringBuilder builder = new StringBuilder();
        if (value instanceof PairList) {
            PairList pairList = (PairList)value;
            String separator = PART_SEPARATOR;
            if (EFeatureToggle.BMW_BUILD_SCRIPT_COMPATIBILITY_MODE.isEnabled()) {
                separator = PART_SEPARATOR_WITH_SPACE;
            }
            for (int i = 0; i < pairList.size(); ++i) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(pairList.getFirst(i)).append(separator).append(pairList.getSecond(i));
            }
        }
        return builder.toString();
    }

    protected abstract T parseSecond(String var1) throws ProjectConfigurationException;

    @Override
    public @NonNull String normalizeValue(@Nullable String value) throws ProjectConfigurationException {
        return PairListOptionDescriptorBase.getValueAsString(this.parseValue(value));
    }
}

