/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.option.server.ServerOptionIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public record ServerReference(EAuthenticationTool authenticationTool, String serverName) {
    private static final String SINGLE_SERVER_PATTERN_PART = "((" + Arrays.stream(EAuthenticationTool.values()).map(EAuthenticationTool::getDisplayName).map(Pattern::quote).collect(Collectors.joining("|")) + ")" + Pattern.quote(":") + "[^,]+)";
    private static final Pattern USER_SERVER_PATTERN = Pattern.compile("\\s*(" + SINGLE_SERVER_PATTERN_PART + ")(\\s*,\\s*" + SINGLE_SERVER_PATTERN_PART + ")*\\s*", 2);

    public ServerReference {
        Objects.requireNonNull(authenticationTool, "authenticationTool");
        Objects.requireNonNull(serverName, "serverName");
    }

    public static Optional<String> validate(String referenceString, ServerOptionIndex optionIndex, String referenceName) throws StorageException {
        Optional<String> validationError = ServerReference.validateSyntax(referenceString, referenceName);
        if (validationError.isPresent()) {
            return validationError;
        }
        for (ServerReference server : ServerReference.parse(referenceString)) {
            if (AuthenticationToolUtils.getServerNames(server.authenticationTool(), optionIndex).contains(server.serverName())) continue;
            return Optional.of(referenceName + " '" + String.valueOf(server) + "' does not exist");
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static Optional<String> validateSyntax(String referenceString, String referenceName) {
        if (StringUtils.isEmpty((String)referenceString)) {
            return Optional.empty();
        }
        if (!USER_SERVER_PATTERN.matcher(referenceString).matches()) {
            return Optional.of(referenceName + " must be a comma separated list of <servertype>:<servername>, where <servertype> is one of " + Arrays.stream(EAuthenticationTool.values()).map(EAuthenticationTool::getDisplayName).collect(Collectors.joining(", ")));
        }
        return Optional.empty();
    }

    public static List<ServerReference> parse(String referenceString) {
        String[] authenticatorParts;
        if (StringUtils.isEmpty((String)referenceString)) {
            return Collections.emptyList();
        }
        ArrayList<ServerReference> result = new ArrayList<ServerReference>();
        for (String authenticatorString : authenticatorParts = referenceString.split(",")) {
            String[] parts = authenticatorString.trim().split(":", 2);
            EAuthenticationTool tool = EAuthenticationTool.byDisplayName(parts[0]).orElseThrow(() -> new IllegalArgumentException("Could not find authentication tool: " + parts[0]));
            result.add(new ServerReference(tool, parts[1]));
        }
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf((Object)this.authenticationTool) + ":" + this.serverName;
    }
}

