/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.config;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class TeamscaleSystemProperties {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final SystemPropertyOptional<Integer> HUBSPOT_CHAT_PORTAL_ID = SystemProperty.ofInteger("com.teamscale.chat-support.portal-id").asOptional();
    public static final SystemPropertyOptional<Boolean> BACKUP_IMPORT_USE_SYSTEM_CHARSET = SystemProperty.ofBoolean("com.teamscale.backup.import.use-system-charset").asOptional();
    public static final SystemProperty<Integer> POLARION_WORKITEM_PAGINATION_SIZE = SystemProperty.ofInteger("com.teamscale.polarion.workitem_pagination_size").withDefault(100);
    public static final SystemProperty<Integer> SESSION_IDLE_TIMEOUT_DURATION = SystemProperty.ofInteger("com.teamscale.session-idle-timeout").withDefault(90);
    public static final SystemProperty<Integer> SESSION_MAX_DURATION = SystemProperty.ofInteger("com.teamscale.session-timeout").withDefault(8);
    public static final SystemProperty<Integer> SESSION_EXPIRATION_UPDATE_TIME = SystemProperty.ofInteger("com.teamscale.session-expiration-update-time").withDefault(60);
    public static final SystemProperty<Boolean> AUTHENTICATION_DISABLED = SystemProperty.ofBoolean("com.teamscale.dev.disable-authentication");
    public static final SystemProperty<String> CUSTOM_AWS_REGIONS = SystemProperty.ofString("com.teamscale.aws.custom_regions");
    public static final SystemPropertyOptional<String> AWS_REGION = SystemProperty.ofString("com.teamscale.aws.region").asOptional();
    public static final SystemPropertyOptional<Integer> S3_REQUEST_TIMEOUT_SECONDS = SystemProperty.ofInteger("com.teamscale.aws.s3.request_timeout").asOptional();
    public static final SystemPropertyOptional<Integer> S3_THREAD_POOL_SIZE = SystemProperty.ofInteger("com.teamscale.aws.s3.thread_pool_size").asOptional();
    public static final SystemProperty<Integer> S3_CHANGE_RETRIEVER_MAXIMUM_BLOCK_TIME_MINUTES = SystemProperty.ofInteger("com.teamscale.aws.s3.max_block_time_minutes").withDefault(240);
    public static final SystemProperty<Boolean> FORCE_DISABLE_GITHUB_CHECK_RUN_CLEANUP = SystemProperty.ofBoolean("com.teamscale.github.disable-check-run-cleanup");
    public static final SystemProperty<Boolean> GIT_KEEP_RESURRECTED_BRANCH_HISTORY = SystemProperty.ofBoolean("com.teamscale.git.keep_resurrected_branch_history").withDefault(true);
    public static final SystemPropertyOptional<List<String>> EXCLUDED_MERGE_REQUEST_SOURCE_BRANCHES = SystemProperty.of("com.teamscale.mergerequest.excluded_source_branches", value -> StringUtils.splitToList((String)value, (String)","), null).asOptional();
    public static final SystemProperty<Pattern> GIT_MESSAGE_PARSER_BRANCH_TRANSFORMATION_PATTERN = SystemProperty.ofPattern("com.teamscale.git.message-parser.branch-transformation.pattern");
    public static final SystemProperty<String> GIT_MESSAGE_PARSER_BRANCH_TRANSFORMATION_REPLACEMENT = SystemProperty.ofString("com.teamscale.git.message-parser.branch-transformation.replacement");
    public static final SystemProperty<Integer> MAX_TRIGGER_PARALLEL_THREADS = SystemProperty.ofInteger("com.teamscale.supporting-workers.max").withDefault(4);
    public static final SystemPropertyOptional<Pattern> DISABLED_TRIGGER_PARALLELIZATION = SystemProperty.ofPattern("com.teamscale.supporting-workers.disabled-for").asOptional();
    public static final SystemProperty<Boolean> FORCE_ADMIN_CREATION = SystemProperty.ofBoolean("com.teamscale.force-create-admin");
    public static final SystemProperty<Boolean> PREVENT_ADMIN_CREATION = SystemProperty.ofBoolean("com.teamscale.dev.prevent-create-admin");
    public static final SystemProperty<Duration> COMPOSER_TIMEOUT = SystemProperty.of("com.teamscale.php.composer.timeout", Duration::parse, Duration.ZERO);
    public static final SystemProperty<Duration> PHPSTAN_TIMEOUT = SystemProperty.of("com.teamscale.php.phpstan.timeout", Duration::parse, Duration.ZERO);
    public static final SystemPropertyOptional<String> REQUIREMENTS_CSV_ID_PATTERN = SystemProperty.ofString("com.teamscale.requirements-csv.pattern").asOptional();
    public static final SystemProperty<Duration> SWIFTLINT_TIMEOUT = SystemProperty.of("com.teamscale.swiftlint.timeout", Duration::parse, Duration.ofMinutes(10L));
    public static final SystemProperty<Integer> TFS_MAXIMUM_NUMBER_OF_PATHS_IN_SINGLE_REQUEST = SystemProperty.ofInteger("com.teamscale.tfs.max-number-of-paths-in-single-request").withDefault(7000);
    public static final SystemProperty<String> SEMGREP_WSL_EXECUTABLE_INSTALL_PATH = SystemProperty.ofString("com.teamscale.semgrep.wsl.executable.path").withDefault("/home/teamscale/.local/bin/semgrep");
    public static final SystemProperty<@Nullable String> IGNORED_PULL_REQUESTS = SystemProperty.ofString("com.teamscale.ignored-pull-requests").withDefault(null);
    public static final SystemProperty<String> HELM_EXE_PATH = SystemProperty.ofString("com.teamscale.worker.helm-executable").withDefault("helm");
    public static final SystemProperty<String> KUSTOMIZE_EXE_PATH = SystemProperty.ofString("com.teamscale.worker.kustomize-executable").withDefault("kustomize");
    public static final SystemPropertyOptional<String> OVERWRITE_EXTERNAL_STORAGE_URI = SystemProperty.ofString("com.teamscale.external-storage.overwrite.uri").asOptional();
    public static final SystemPropertyOptional<Pattern> DISABLED_FINDINGS_TRACKING_APPROXIMATE_MATCHING_STRATEGY = SystemProperty.ofPattern("com.teamscale.findings-tracking-matching.disabled-for").asOptional();
    public static final SystemProperty<Integer> FINDING_TRACKING_BATCH_SIZE = SystemProperty.ofInteger("com.teamscale.findings-tracking.batch-size").withDefault(2000);

    private TeamscaleSystemProperties() {
    }

    public static final class SystemProperty<T> {
        private final String name;
        private final Function<String, T> converter;
        private final @Nullable T defaultValue;

        private SystemProperty(@NonNull String name, @NonNull Function<String, T> converter, @Nullable T defaultValue) {
            this.name = name;
            this.converter = converter;
            this.defaultValue = defaultValue;
        }

        public SystemProperty<T> withDefault(@Nullable T defaultValue) {
            return new SystemProperty<T>(this.name, this.converter, defaultValue);
        }

        public String getName() {
            return this.name;
        }

        public @Nullable T getValue() {
            return this.readSystemPropertyValue().orElse(this.defaultValue);
        }

        Optional<T> readSystemPropertyValue() {
            CCSMAssert.isNotNull((Object)this.name, () -> String.format("Expected \"%s\" to be not null", "name"));
            CCSMAssert.isNotNull(this.converter, () -> String.format("Expected \"%s\" to be not null", "converter"));
            String property = System.getProperty(this.name);
            Object value = null;
            if (property != null) {
                try {
                    value = this.converter.apply(property);
                }
                catch (RuntimeException e) {
                    LOGGER.error("Unable to parse \"{}\" value \"{}\"", (Object)this.name, (Object)property, (Object)e);
                }
            }
            return Optional.ofNullable(value);
        }

        public String toString() {
            return this.name + ": " + String.valueOf(this.getValue());
        }

        private static SystemProperty<Integer> ofInteger(String name) {
            return SystemProperty.of(name, Integer::decode, 0);
        }

        private static SystemProperty<Boolean> ofBoolean(String name) {
            return SystemProperty.of(name, Boolean::parseBoolean, false);
        }

        private static SystemProperty<String> ofString(String name) {
            return SystemProperty.of(name, Function.identity(), "");
        }

        private static SystemProperty<Pattern> ofPattern(String name) {
            return SystemProperty.of(name, Pattern::compile, null);
        }

        private static <T> SystemProperty<T> of(String name, Function<String, T> converter, @Nullable T defaultValue) {
            return new SystemProperty<T>(name, converter, defaultValue);
        }

        public SystemPropertyOptional<T> asOptional() {
            return new SystemPropertyOptional(this);
        }
    }

    public static final class SystemPropertyOptional<T> {
        private final SystemProperty<T> delegate;

        public SystemPropertyOptional(SystemProperty<T> delegate) {
            this.delegate = delegate;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public Optional<T> getValue() {
            return this.delegate.readSystemPropertyValue();
        }
    }
}

