/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings.metrics;

import com.teamscale.core.findings.metrics.BlacklistCountMetric;
import com.teamscale.core.findings.metrics.FindingsCountForAllCategoriesMetric;
import com.teamscale.core.findings.metrics.FindingsCountMetric;
import com.teamscale.core.findings.metrics.FindingsMetricBase;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public enum EFindingsMetricCategory {
    ALL(FindingsCountMetric.FINDINGS_COUNT, FindingsCountForAllCategoriesMetric.FINDINGS_COUNT_FOR_ALL_CATEGORIES, BlacklistCountMetric.FALSE_POSITIVE, BlacklistCountMetric.TOLERATED, BlacklistCountMetric.COMPLETE, ETrafficLightColor.UNKNOWN),
    RED(FindingsCountMetric.FINDINGS_COUNT_RED, FindingsCountForAllCategoriesMetric.FINDINGS_COUNT_FOR_ALL_CATEGORIES_RED, BlacklistCountMetric.FALSE_POSITIVE_RED, BlacklistCountMetric.TOLERATED_RED, BlacklistCountMetric.COMPLETE_RED, ETrafficLightColor.RED),
    YELLOW(FindingsCountMetric.FINDINGS_COUNT_YELLOW, FindingsCountForAllCategoriesMetric.FINDINGS_COUNT_FOR_ALL_CATEGORIES_YELLOW, BlacklistCountMetric.FALSE_POSITIVE_YELLOW, BlacklistCountMetric.TOLERATED_YELLOW, BlacklistCountMetric.COMPLETE_YELLOW, ETrafficLightColor.YELLOW);

    private final FindingsCountMetric findingsCountMetric;
    private final FindingsCountForAllCategoriesMetric findingsSummaryMetric;
    private final BlacklistCountMetric falsePositiveBlacklistCountMetric;
    private final BlacklistCountMetric toleratedBlacklistCountMetric;
    private final BlacklistCountMetric completeBlacklistCountMetric;
    private final ETrafficLightColor trafficLightColor;
    public static final UnmodifiableSet<String> ALL_IDS;

    private EFindingsMetricCategory(FindingsCountMetric findingsCountMetric, FindingsCountForAllCategoriesMetric findingsSummaryMetric, BlacklistCountMetric falsePositiveBlacklistCountMetric, BlacklistCountMetric toleratedBlacklistCountMetric, BlacklistCountMetric completeBlacklistCountMetric, ETrafficLightColor trafficLightColor) {
        this.findingsCountMetric = findingsCountMetric;
        this.findingsSummaryMetric = findingsSummaryMetric;
        this.falsePositiveBlacklistCountMetric = falsePositiveBlacklistCountMetric;
        this.toleratedBlacklistCountMetric = toleratedBlacklistCountMetric;
        this.completeBlacklistCountMetric = completeBlacklistCountMetric;
        this.trafficLightColor = trafficLightColor;
    }

    private static UnmodifiableSet<String> computeAllIds() {
        List<Function> metricProviders = Arrays.asList(EFindingsMetricCategory::getFindingsCountMetric, EFindingsMetricCategory::getFindingsSummaryMetric, EFindingsMetricCategory::getCompleteBlacklistCountMetric, EFindingsMetricCategory::getToleratedBlacklistCountMetric, EFindingsMetricCategory::getFalsePositiveBlacklistCountMetric);
        HashSet<String> result = new HashSet<String>();
        for (EFindingsMetricCategory metricCategory : EFindingsMetricCategory.values()) {
            for (Function metricProvider : metricProviders) {
                result.add(((FindingsMetricBase)metricProvider.apply(metricCategory)).getId());
            }
        }
        return CollectionUtils.asUnmodifiable(result);
    }

    public FindingsCountMetric getFindingsCountMetric() {
        return this.findingsCountMetric;
    }

    public FindingsCountForAllCategoriesMetric getFindingsSummaryMetric() {
        return this.findingsSummaryMetric;
    }

    public BlacklistCountMetric getFalsePositiveBlacklistCountMetric() {
        return this.falsePositiveBlacklistCountMetric;
    }

    public BlacklistCountMetric getToleratedBlacklistCountMetric() {
        return this.toleratedBlacklistCountMetric;
    }

    public BlacklistCountMetric getCompleteBlacklistCountMetric() {
        return this.completeBlacklistCountMetric;
    }

    public ETrafficLightColor getTrafficLightColor() {
        return this.trafficLightColor;
    }

    static {
        ALL_IDS = EFindingsMetricCategory.computeAllIds();
    }
}

