/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.profiler;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import java.util.stream.Stream;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ShortProfilerLog
extends ShortLogEntryBase {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_PROPERTY_NAME = "message";
    private static final String LEVEL_PROPERTY_NAME = "level";
    @JsonProperty(value="level")
    private final ELogLevel level;
    @JsonProperty(value="message")
    private final String message;

    public ShortProfilerLog(LogEntryIdentifier id, int debugDetails, int fatalDetails, int errorDetails, int warningDetails, String message) {
        this(id, ELogLevel.fromCounts((int)errorDetails, (int)warningDetails, (int)debugDetails), debugDetails, fatalDetails, errorDetails, warningDetails, message);
    }

    public ShortProfilerLog(LogEntryIdentifier id, ELogLevel level, int debugDetails, int fatalDetails, int errorDetails, int warningDetails, String message) {
        super(id, debugDetails, fatalDetails, errorDetails, warningDetails, null);
        this.level = level;
        this.message = message;
    }

    @Override
    protected void appendFields(StringBuilder builder) {
        builder.append(ELogLevel.fromCounts((int)this.getErrorCount(), (int)this.getWarningCount(), (int)this.getDebugCount())).append("\t");
        builder.append(this.getTimestampFormattedWithZone()).append("\t");
        builder.append(this.message).append("\n ");
    }

    @Override
    protected void appendErrorStatistics(StringBuilder builder) {
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.message));
    }
}

