/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IMultiStoreMigrator;
import com.teamscale.core.migration.store.ISingleStoreMigrator;
import com.teamscale.core.migration.store.IStorageMigrator;
import com.teamscale.core.spi.TeamscaleServiceLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.jetbrains.annotations.VisibleForTesting;

public class StorageMigrationRegistry {
    private static StorageMigrationRegistry instance;
    private final TwoDimHashMap<EStorageSystemVersion, String, IStorageMigrator> globalMigrators = new TwoDimHashMap();
    private final SetMap<EStorageSystemVersion, String> globalOutputStores = new SetMap();
    private final SetMap<EStorageSystemVersion, String> globalInputStores = new SetMap();
    private final TwoDimHashMap<EStorageSystemVersion, String, IStorageMigrator> projectMigrators = new TwoDimHashMap();
    private final SetMap<EStorageSystemVersion, String> projectOutputStores = new SetMap();
    private final SetMap<EStorageSystemVersion, String> projectInputStores = new SetMap();
    private final TwoDimHashMap<EStorageSystemVersion, String, String> newStoreNames = new TwoDimHashMap();
    private final SetMap<EStorageSystemVersion, String> storeDeletions = new SetMap();

    @VisibleForTesting
    public StorageMigrationRegistry() {
        this.registerStoreDeletions();
        this.registerStoreRenames();
        this.discoverStorageMigrators();
    }

    private void discoverStorageMigrators() {
        TeamscaleServiceLoader.loadAll(IStorageMigrator.class).forEach(this::registerDiscoveredMigrator);
    }

    private void registerDiscoveredMigrator(IStorageMigrator storageMigrator) {
        if (storageMigrator instanceof ISingleStoreMigrator) {
            ISingleStoreMigrator singleStoreMigrator = (ISingleStoreMigrator)storageMigrator;
            HashSet<String> stores = new HashSet<String>();
            stores.add(singleStoreMigrator.getStoreName());
            stores.addAll(singleStoreMigrator.getAdditionalStoreNames());
            block8: for (String store : stores) {
                switch (storageMigrator.getType()) {
                    case GLOBAL: {
                        this.registerGlobalMigrator(store, singleStoreMigrator);
                        continue block8;
                    }
                    case PROJECT: {
                        this.registerProjectMigrator(store, singleStoreMigrator);
                        continue block8;
                    }
                }
                throw new AssertionError((Object)("Unknown storage migrator type: " + String.valueOf((Object)storageMigrator.getType())));
            }
        } else if (storageMigrator instanceof IMultiStoreMigrator) {
            IMultiStoreMigrator multiStoreMigrator = (IMultiStoreMigrator)storageMigrator;
            switch (storageMigrator.getType()) {
                case GLOBAL: {
                    this.registerGlobalMultiStoreMigrator(multiStoreMigrator);
                    break;
                }
                case PROJECT: {
                    StorageMigrationRegistry.registerMultiStoreMigrator(multiStoreMigrator, this.projectMigrators, this.projectInputStores, this.projectOutputStores);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown storage migrator type: " + String.valueOf((Object)storageMigrator.getType())));
                }
            }
        }
    }

    public static synchronized StorageMigrationRegistry getInstance() {
        if (instance == null) {
            instance = new StorageMigrationRegistry();
        }
        return instance;
    }

    private void registerStoreDeletions() {
        this.registerStoreDeletion(EStorageSystemVersion.STORAGE_SYSTEM_V121, "analysis-profile-edit-versions");
        this.registerStoreDeletion(EStorageSystemVersion.STORAGE_SYSTEM_V119, "javascript-source-mappings");
        this.registerStoreDeletion(EStorageSystemVersion.STORAGE_SYSTEM_V119, "javascript-sourcemap-versions");
        this.registerStoreDeletion(EStorageSystemVersion.STORAGE_SYSTEM_V157, "retrospective-index");
        this.registerStoreDeletion(EStorageSystemVersion.STORAGE_SYSTEM_V183, "user-activity");
    }

    private void registerStoreRenames() {
        this.registerStoreRenaming("user-recently-viewed-branches", EStorageSystemVersion.STORAGE_SYSTEM_V109, "user-recently-interacted-branches");
    }

    @VisibleForTesting
    synchronized void registerGlobalMigrator(String storeName, IStorageMigrator migrator) {
        StorageMigrationRegistry.registerMigrator(storeName, migrator, this.globalMigrators, this.globalInputStores, this.globalOutputStores);
    }

    @VisibleForTesting
    synchronized void registerGlobalMultiStoreMigrator(IMultiStoreMigrator migrator) {
        StorageMigrationRegistry.registerMultiStoreMigrator(migrator, this.globalMigrators, this.globalInputStores, this.globalOutputStores);
    }

    @VisibleForTesting
    synchronized void registerProjectMigrator(String storeName, IStorageMigrator migrator) {
        StorageMigrationRegistry.registerMigrator(storeName, migrator, this.projectMigrators, this.projectInputStores, this.projectOutputStores);
    }

    private static synchronized void registerMultiStoreMigrator(IMultiStoreMigrator migrator, TwoDimHashMap<EStorageSystemVersion, String, IStorageMigrator> migrators, SetMap<EStorageSystemVersion, String> migratedInputStores, SetMap<EStorageSystemVersion, String> migratedOutputStores) {
        EStorageSystemVersion version = migrator.getVersion();
        Set inputStores = (Set)migratedInputStores.getCollectionOrEmpty((Object)version);
        Set outputStores = (Set)migratedOutputStores.getCollectionOrEmpty((Object)version);
        Set<String> migratorInputStores = migrator.getInputStoreNames();
        Set<String> migratorOutputStores = migrator.getOutputStoreNames();
        List conflictingInputStores = CollectionUtils.filter(migratorInputStores, migratorInputStore -> inputStores.stream().anyMatch(inputStore -> inputStore.equals(migratorInputStore)));
        List conflictingOutputStores = CollectionUtils.filter(migratorOutputStores, migratorOutputStore -> outputStores.stream().anyMatch(outputStore -> outputStore.equals(migratorOutputStore)));
        CCSMAssert.isTrue((boolean)conflictingInputStores.isEmpty(), () -> "Multiple migrations use the same input stores in storage system version " + String.valueOf((Object)version) + ": " + String.valueOf(conflictingInputStores));
        CCSMAssert.isTrue((boolean)conflictingOutputStores.isEmpty(), () -> "Multiple migrations use the same output stores in storage system version " + String.valueOf((Object)version) + ": " + String.valueOf(conflictingOutputStores));
        migratorInputStores.forEach(storeName -> migrators.putValue((Object)version, storeName, (Object)migrator));
        migratedInputStores.addAll((Object)version, migratorInputStores);
        migratedOutputStores.addAll((Object)version, migratorOutputStores);
    }

    @VisibleForTesting
    synchronized void registerStoreDeletion(EStorageSystemVersion storageSystemVersion, String storeName) {
        this.storeDeletions.add((Object)storageSystemVersion, (Object)storeName);
    }

    @VisibleForTesting
    synchronized void registerStoreRenaming(String storeName, EStorageSystemVersion targetVersion, String newStoreName) {
        CCSMAssert.isTrue((this.newStoreNames.getValue((Object)targetVersion, (Object)storeName) == null ? 1 : 0) != 0, () -> "May not register multiple renamings for store " + storeName + " in version " + String.valueOf((Object)targetVersion));
        CCSMAssert.isTrue((this.newStoreNames.getValue((Object)targetVersion, (Object)newStoreName) == null ? 1 : 0) != 0, () -> "May not register circular renamings for store " + storeName + " in version " + String.valueOf((Object)targetVersion));
        this.newStoreNames.putValue((Object)targetVersion, (Object)storeName, (Object)newStoreName);
    }

    private static void registerMigrator(String storeName, IStorageMigrator migrator, TwoDimHashMap<EStorageSystemVersion, String, IStorageMigrator> migrators, SetMap<EStorageSystemVersion, String> migratedInputStores, SetMap<EStorageSystemVersion, String> migratedOutputStores) {
        EStorageSystemVersion version = migrator.getVersion();
        CCSMAssert.isFalse((boolean)((Set)migratedInputStores.getCollectionOrEmpty((Object)version)).contains(storeName), () -> "Can't use store " + storeName + " as input multiple times for version " + String.valueOf((Object)version));
        CCSMAssert.isFalse((boolean)((Set)migratedOutputStores.getCollectionOrEmpty((Object)version)).contains(storeName), () -> "Can't use store" + storeName + " as output multiple times.");
        migrators.putValue((Object)version, (Object)storeName, (Object)migrator);
        migratedInputStores.add((Object)version, (Object)storeName);
        migratedOutputStores.add((Object)version, (Object)storeName);
    }

    public Map<String, IStorageMigrator> getProjectMigrators(EStorageSystemVersion storageSystemVersion) {
        return StorageMigrationRegistry.getMapOrEmpty(this.projectMigrators.getSecondMap((Object)storageSystemVersion));
    }

    public Map<String, IStorageMigrator> getGlobalMigrators(EStorageSystemVersion storageSystemVersion) {
        return StorageMigrationRegistry.getMapOrEmpty(this.globalMigrators.getSecondMap((Object)storageSystemVersion));
    }

    public Map<String, String> getStoreRenames(EStorageSystemVersion storageSystemVersion) {
        return StorageMigrationRegistry.getMapOrEmpty(this.newStoreNames.getSecondMap((Object)storageSystemVersion));
    }

    public Set<String> getStoreDeletionPatterns(EStorageSystemVersion storageSystemVersion) {
        return (Set)this.storeDeletions.getCollectionOrEmpty((Object)storageSystemVersion);
    }

    private static <K, V> Map<K, V> getMapOrEmpty(Map<K, V> map) {
        if (map == null) {
            return CollectionUtils.emptyMap();
        }
        return map;
    }

    @VisibleForTesting
    public Set<EStorageSystemVersion> getRegisteredStorageSystemVersions() {
        HashSet<EStorageSystemVersion> registeredVersions = new HashSet<EStorageSystemVersion>();
        registeredVersions.addAll((Collection<EStorageSystemVersion>)this.storeDeletions.getKeys());
        registeredVersions.addAll(this.newStoreNames.getFirstKeys());
        registeredVersions.addAll((Collection<EStorageSystemVersion>)this.globalInputStores.getKeys());
        registeredVersions.addAll((Collection<EStorageSystemVersion>)this.projectInputStores.getKeys());
        return registeredVersions;
    }
}

