/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.google.common.hash.HashCode;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.runtime.impl.worker.DelegatingHashingStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.engine.persistence.store.branched.IHashingStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class RecordingStore
extends DelegatingStore {
    private final Map<StorageKey, HashCode> modifiedKeysToInitialValueHash = new HashMap<StorageKey, HashCode>();
    private final Set<StorageKey> removedKeys = new HashSet<StorageKey>();
    private final boolean underlyingStoreIsVirtual;
    private final IHashingStore store;

    public RecordingStore(IStore delegate) {
        this(delegate, false);
    }

    public RecordingStore(IStore delegate, boolean underlyingStoreIsVirtual) {
        super(delegate);
        this.underlyingStoreIsVirtual = underlyingStoreIsVirtual;
        this.store = delegate instanceof IHashingStore ? (IHashingStore)delegate : new DelegatingHashingStore(delegate);
    }

    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        HashCode oldHash = IHashingStore.NULL;
        HashCode newHashCode = this.store.calculateHash(value);
        if (!this.underlyingStoreIsVirtual && newHashCode.equals((Object)(oldHash = this.store.getHash(key)))) {
            return;
        }
        this.recordPut(key, oldHash, newHashCode);
        this.store.put(key, value);
    }

    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        PairList keyToOldAndNewHash = new PairList();
        if (this.underlyingStoreIsVirtual) {
            for (int i = 0; i < keysValues.size(); ++i) {
                HashCode newHash = this.store.calculateHash((byte[])keysValues.getSecond(i));
                StorageKey storageKey = new StorageKey((byte[])keysValues.getFirst(i));
                keyToOldAndNewHash.add((Object)storageKey, (Object)Pair.createPair((Object)IHashingStore.NULL, (Object)newHash));
            }
            this.recordPuts((PairList<StorageKey, Pair<HashCode, HashCode>>)keyToOldAndNewHash);
            this.store.put(keysValues);
            return;
        }
        List keys = keysValues.extractFirstList();
        List oldHashes = this.store.getHash(keys);
        PairList reduced = new PairList();
        for (int i = 0; i < keysValues.size(); ++i) {
            byte[] value;
            HashCode newHash;
            HashCode oldHash = (HashCode)oldHashes.get(i);
            if (oldHash.equals((Object)(newHash = this.store.calculateHash(value = (byte[])keysValues.getSecond(i))))) continue;
            byte[] key = (byte[])keysValues.getFirst(i);
            reduced.add((Object)key, (Object)value);
            StorageKey storageKey = new StorageKey(key);
            keyToOldAndNewHash.add((Object)storageKey, (Object)Pair.createPair((Object)oldHash, (Object)newHash));
        }
        this.recordPuts((PairList<StorageKey, Pair<HashCode, HashCode>>)keyToOldAndNewHash);
        if (!reduced.isEmpty()) {
            this.store.put(reduced);
        }
    }

    private synchronized void recordPuts(PairList<StorageKey, Pair<HashCode, HashCode>> keyToOldAndNewHash) {
        for (Pair keyToOldAndNewHashEntry : keyToOldAndNewHash) {
            this.removedKeys.remove(keyToOldAndNewHashEntry.getFirst());
            this.modifiedKeysToInitialValueHash.compute((StorageKey)keyToOldAndNewHashEntry.getFirst(), (k, existingHash) -> {
                if (existingHash == null) {
                    return (HashCode)((Pair)keyToOldAndNewHashEntry.getSecond()).getFirst();
                }
                if (((HashCode)((Pair)keyToOldAndNewHashEntry.getSecond()).getSecond()).equals(existingHash)) {
                    return null;
                }
                return existingHash;
            });
        }
    }

    public void remove(byte @NonNull [] key) throws StorageException {
        HashCode oldHash = IHashingStore.NULL;
        if (!this.underlyingStoreIsVirtual && IHashingStore.NULL.equals((Object)(oldHash = this.store.getHash(key)))) {
            return;
        }
        this.recordRemove(key, oldHash);
        this.store.remove(key);
    }

    public void remove(List<byte @NonNull []> keys) throws StorageException {
        if (this.underlyingStoreIsVirtual) {
            for (byte[] key : keys) {
                this.recordRemove(key, IHashingStore.NULL);
            }
            this.store.remove(keys);
            return;
        }
        List oldHashes = this.store.getHash(keys);
        ArrayList<byte[]> reducedKeys = new ArrayList<byte[]>();
        ArrayList<HashCode> hashesToRemove = new ArrayList<HashCode>();
        for (int i = 0; i < keys.size(); ++i) {
            HashCode oldHash = (HashCode)oldHashes.get(i);
            if (IHashingStore.NULL.equals((Object)oldHash)) continue;
            byte[] key = keys.get(i);
            hashesToRemove.add(oldHash);
            reducedKeys.add(key);
        }
        this.recordRemoves(reducedKeys, hashesToRemove);
        if (!reducedKeys.isEmpty()) {
            this.store.remove(reducedKeys);
        }
    }

    private synchronized void recordRemoves(List<byte[]> reducedKeys, List<HashCode> hashesToRemove) {
        for (int i = 0; i < reducedKeys.size(); ++i) {
            StorageKey storageKey = new StorageKey(reducedKeys.get(i));
            this.removedKeys.add(storageKey);
            this.modifiedKeysToInitialValueHash.putIfAbsent(storageKey, hashesToRemove.get(i));
        }
    }

    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        if (this.underlyingStoreIsVirtual) {
            throw new StorageException("Prefix removal not supported for virtual stores!");
        }
        List keys = StorageUtils.listKeysStartingWith((byte[])prefix, (IStore)this);
        List oldHashes = this.store.getHash(keys);
        this.recordRemoves(keys, oldHashes);
        super.removeByPrefix(prefix);
    }

    public synchronized KeyDelta obtainDelta() {
        HashSet addedOrChanged = CollectionUtils.differenceSet(this.modifiedKeysToInitialValueHash.keySet(), (Collection[])new Collection[]{this.removedKeys});
        return new KeyDelta(addedOrChanged, (Collection<StorageKey>)this.removedKeys);
    }

    private synchronized void recordPut(byte[] key, @NonNull HashCode oldHashFromStore, @NonNull HashCode newValueHash) {
        StorageKey storageKey = new StorageKey(key);
        this.removedKeys.remove(storageKey);
        this.modifiedKeysToInitialValueHash.compute(storageKey, (k, existingHash) -> {
            if (existingHash == null) {
                return oldHashFromStore;
            }
            if (newValueHash.equals(existingHash)) {
                return null;
            }
            return existingHash;
        });
    }

    private synchronized void recordRemove(byte[] key, @NonNull HashCode hashCode) {
        StorageKey storageKey = new StorageKey(key);
        this.removedKeys.add(storageKey);
        this.modifiedKeysToInitialValueHash.putIfAbsent(storageKey, hashCode);
    }
}

