/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.tfs.TfsWorkItem;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.BidirectionalMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface IWorkItemRestClient
extends IRetrofitApi {
    public static final int MAX_IDS_PER_QUERY_RESULT = 19999;
    public static final int WORK_ITEMS_PER_CALL = 150;
    public static final String EXPAND_RELATIONS = "relations";

    @GET(value="_apis/wit/workitemrelationtypes?api-version=6.0")
    public GetWorkItemRelationTypesResponse getWorkItemRelationTypes() throws ServiceCallException;

    @GET(value="_apis/wit/reporting/workitemlinks?api-version=6.0")
    public GetWorkItemLinkUpdatesResponse getWorkItemLinkUpdates(@Query(value="linkTypes") @Nullable String var1, @Query(value="types") @Nullable String var2, @Query(value="startDateTime") @Nullable Instant var3, @Query(value="continuationToken") @Nullable String var4) throws ServiceCallException;

    @GET(value="{project}/_apis/wit/reporting/workitemlinks?api-version=6.0")
    public GetWorkItemLinkUpdatesResponse getWorkItemLinkUpdatesForProject(@Path(value="project") String var1, @Query(value="linkTypes") @Nullable String var2, @Query(value="types") @Nullable String var3, @Query(value="startDateTime") @Nullable Instant var4, @Query(value="continuationToken") @Nullable String var5) throws ServiceCallException;

    @POST(value="_apis/wit/wiql?api-version=5.0&$top=19999")
    @Headers(value={"Content-Type: application/json"})
    public WorkItemIds getWorkItemIds(@Body WiqlQuery var1) throws ServiceCallException;

    @GET(value="_apis/wit/workitems?api-version=1.0&$expand=relations")
    public WorkItems getWorkItemsWithRelations(@Query(value="ids") String var1) throws ServiceCallException;

    @GET(value="_apis/wit/workitems?api-version=1.0")
    public WorkItems getWorkItems(@Query(value="ids") String var1, @Query(value="fields") String var2) throws ServiceCallException;

    @GET(value="_apis/wit/workitems/{id}/revisions?api-version=1.0")
    public WorkItems getWorkItemRevision(@Path(value="id") String var1, @Query(value="$skip") int var2, @Query(value="$expand") String var3) throws ServiceCallException;

    @GET(value="_apis/wit/fields?api-version=1.0")
    public FieldTypes getFieldDefinitions() throws ServiceCallException;

    public static class GetWorkItemLinkUpdatesResponse {
        @JsonProperty(value="continuationToken")
        private final String continuationToken;
        @JsonProperty(value="isLastBatch")
        private final boolean lastBatch;
        @JsonProperty(value="values")
        private final List<WorkItemLinkUpdate> linkUpdates;

        @JsonCreator
        public GetWorkItemLinkUpdatesResponse(@JsonProperty(value="continuationToken") String continuationToken, @JsonProperty(value="isLastBatch") boolean lastBatch, @JsonProperty(value="values") List<WorkItemLinkUpdate> linkUpdates) {
            this.continuationToken = continuationToken;
            this.lastBatch = lastBatch;
            this.linkUpdates = linkUpdates;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public boolean isLastBatch() {
            return this.lastBatch;
        }

        public List<WorkItemLinkUpdate> getLinkUpdates() {
            return this.linkUpdates;
        }

        public static class WorkItemLinkUpdate {
            @JsonProperty(value="rel")
            private final String relationType;
            @JsonProperty(value="attributes")
            private final Attributes attributes;

            @JsonCreator
            public WorkItemLinkUpdate(@JsonProperty(value="rel") String relationType, @JsonProperty(value="attributes") Attributes attributes) {
                this.relationType = relationType;
                this.attributes = attributes;
            }

            public String getRelationType() {
                return this.relationType;
            }

            public Attributes getAttributes() {
                return this.attributes;
            }

            public static class Attributes {
                @JsonProperty(value="linkType")
                private final String linkType;
                @JsonProperty(value="sourceId")
                private final int sourceItemId;
                @JsonProperty(value="targetId")
                private final int targetItemId;
                @JsonProperty(value="isActive")
                private final boolean active;
                @JsonProperty(value="changedDate")
                private final ZonedDateTime changedDate;
                @JsonProperty(value="changedBy")
                private final UserContainer changedBy;
                @JsonProperty(value="changedOperation")
                private final String operation;
                @JsonProperty(value="sourceProjectId")
                private final String sourceProjectId;
                @JsonProperty(value="targetProjectId")
                private final String targetProjectId;

                @JsonCreator
                public Attributes(@JsonProperty(value="linkType") String linkType, @JsonProperty(value="sourceId") int sourceItemId, @JsonProperty(value="targetId") int targetItemId, @JsonProperty(value="isActive") boolean active, @JsonProperty(value="changedDate") ZonedDateTime changedDate, @JsonProperty(value="changedBy") UserContainer changedBy, @JsonProperty(value="changedOperation") String operation, @JsonProperty(value="sourceProjectId") String sourceProjectId, @JsonProperty(value="targetProjectId") String targetProjectId) {
                    this.linkType = linkType;
                    this.sourceItemId = sourceItemId;
                    this.targetItemId = targetItemId;
                    this.active = active;
                    this.changedDate = changedDate;
                    this.changedBy = changedBy;
                    this.operation = operation;
                    this.sourceProjectId = sourceProjectId;
                    this.targetProjectId = targetProjectId;
                }

                public String getLinkType() {
                    return this.linkType;
                }

                public int getSourceItemId() {
                    return this.sourceItemId;
                }

                public int getTargetItemId() {
                    return this.targetItemId;
                }

                public boolean isActive() {
                    return this.active;
                }

                public ZonedDateTime getChangedDate() {
                    return this.changedDate;
                }

                public UserContainer getChangedBy() {
                    return this.changedBy;
                }

                public String getOperation() {
                    return this.operation;
                }

                public String getSourceProjectId() {
                    return this.sourceProjectId;
                }

                public String getTargetProjectId() {
                    return this.targetProjectId;
                }
            }
        }
    }

    public static class GetWorkItemRelationTypesResponse {
        @JsonProperty(value="count")
        private final int count;
        @JsonProperty(value="value")
        private final List<WorkItemRelationType> relations;

        @JsonCreator
        public GetWorkItemRelationTypesResponse(@JsonProperty(value="count") int count, @JsonProperty(value="value") List<WorkItemRelationType> relations) {
            this.count = count;
            this.relations = relations;
        }

        public int getCount() {
            return this.count;
        }

        public List<WorkItemRelationType> getRelations() {
            return this.relations;
        }

        public static class WorkItemRelationType {
            @JsonProperty(value="attributes")
            private final AttributesBase attributes;
            @JsonProperty(value="name")
            private final String name;
            @JsonProperty(value="referenceName")
            private final String referenceName;
            @JsonProperty(value="url")
            private final String url;

            @JsonCreator
            public WorkItemRelationType(@JsonProperty(value="attributes") AttributesBase attributes, @JsonProperty(value="name") String name, @JsonProperty(value="referenceName") String referenceName, @JsonProperty(value="url") String url) {
                this.attributes = attributes;
                this.name = name;
                this.referenceName = referenceName;
                this.url = url;
            }

            public AttributesBase getAttributes() {
                return this.attributes;
            }

            public String getName() {
                return this.name;
            }

            public String getReferenceName() {
                return this.referenceName;
            }

            public String getUrl() {
                return this.url;
            }

            @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="usage", defaultImpl=AttributesBase.class, visible=true)
            @JsonSubTypes(value={@JsonSubTypes.Type(value=WorkItemLinkAttributes.class), @JsonSubTypes.Type(value=ResourceLinkAttributes.class)})
            public static class AttributesBase {
                @JsonProperty(value="usage")
                private final String usage;
                @JsonProperty(value="editable")
                private final boolean editable;
                @JsonProperty(value="enabled")
                private final boolean enabled;

                @JsonCreator
                public AttributesBase(@JsonProperty(value="usage") String usage, @JsonProperty(value="editable") boolean editable, @JsonProperty(value="enabled") boolean enabled) {
                    this.usage = usage;
                    this.editable = editable;
                    this.enabled = enabled;
                }

                public String getUsage() {
                    return this.usage;
                }

                public boolean isEditable() {
                    return this.editable;
                }

                public boolean isEnabled() {
                    return this.enabled;
                }

                public boolean isWorkItemLink() {
                    return false;
                }
            }

            @JsonTypeName(value="resourceLink")
            public static class ResourceLinkAttributes
            extends AttributesBase {
                @JsonCreator
                public ResourceLinkAttributes(@JsonProperty(value="usage") String usage, @JsonProperty(value="editable") boolean editable, @JsonProperty(value="enabled") boolean enabled) {
                    super(usage, editable, enabled);
                }
            }

            @JsonTypeName(value="workItemLink")
            public static class WorkItemLinkAttributes
            extends AttributesBase {
                @JsonProperty(value="acyclic")
                private final boolean acyclic;
                @JsonProperty(value="directional")
                private final boolean directional;
                @JsonProperty(value="singleTarget")
                private final boolean singleTarget;
                @JsonProperty(value="topology")
                private final String topology;
                @JsonProperty(value="isForward")
                private final @Nullable Boolean forward;
                @JsonProperty(value="oppositeEndReferenceName")
                private final @Nullable String oppositeEndReferenceName;

                @JsonCreator
                public WorkItemLinkAttributes(@JsonProperty(value="usage") String usage, @JsonProperty(value="editable") boolean editable, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="acyclic") boolean acyclic, @JsonProperty(value="directional") boolean directional, @JsonProperty(value="singleTarget") boolean singleTarget, @JsonProperty(value="topology") String topology, @JsonProperty(value="isForward") @Nullable Boolean forward, @JsonProperty(value="oppositeEndReferenceName") @Nullable String oppositeEndReferenceName) {
                    super(usage, editable, enabled);
                    this.acyclic = acyclic;
                    this.directional = directional;
                    this.singleTarget = singleTarget;
                    this.topology = topology;
                    this.forward = forward;
                    this.oppositeEndReferenceName = oppositeEndReferenceName;
                }

                public boolean isAcyclic() {
                    return this.acyclic;
                }

                public boolean isDirectional() {
                    return this.directional;
                }

                public boolean isBidirectional() {
                    return !this.isDirectional();
                }

                public boolean isSingleTarget() {
                    return this.singleTarget;
                }

                public String getTopology() {
                    return this.topology;
                }

                public Boolean isForward() {
                    return this.forward;
                }

                public String getOppositeEndReferenceName() {
                    return this.oppositeEndReferenceName;
                }

                @Override
                public boolean isWorkItemLink() {
                    return true;
                }
            }
        }
    }

    public static class WiqlQuery {
        @JsonProperty(value="query")
        private final String query;

        public WiqlQuery(String query) {
            this.query = query;
        }

        public String toString() {
            return this.query;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WiqlQuery)) {
                return false;
            }
            WiqlQuery other = (WiqlQuery)obj;
            return Objects.equals(other.query, this.query);
        }

        public int hashCode() {
            return Objects.hash(this.query);
        }
    }

    public static class FieldTypes {
        @JsonProperty(value="value")
        private List<Type> types;

        public BidirectionalMap<String, String> getNameToReferenceNameMapping() {
            BidirectionalMap bimap = new BidirectionalMap();
            for (Type type : this.types) {
                bimap.put((Object)type.getName(), (Object)type.getReferenceName());
            }
            return bimap;
        }

        private static class Type {
            @JsonProperty(value="name")
            String name;
            @JsonProperty(value="referenceName")
            String referenceName;

            private Type() {
            }

            public String getReferenceName() {
                return this.referenceName;
            }

            public String getName() {
                return this.name;
            }
        }
    }

    public record UserContainer(@JsonProperty(value="displayName") String displayName, @JsonProperty(value="uniqueName") String uniqueName) {
        @Override
        public String toString() {
            return this.displayName + " <" + this.uniqueName + ">";
        }
    }

    public static class WorkItems {
        private static final String VALUE_PROPERTY = "value";
        @JsonProperty(value="value")
        private final List<TfsWorkItem> workItems;

        @JsonCreator
        public WorkItems(@JsonProperty(value="value") List<TfsWorkItem> workItems) {
            this.workItems = workItems;
        }

        public List<TfsWorkItem> getWorkItems() {
            return this.workItems;
        }
    }

    public static class SparseTfsWorkItem {
        @JsonProperty(value="id")
        private String id;

        public String getId() {
            return this.id;
        }

        @JsonCreator
        public SparseTfsWorkItem(@JsonProperty(value="id") String id) {
            this.id = id;
        }
    }

    public static class WorkItemIds {
        @JsonProperty(value="workItems")
        private List<SparseTfsWorkItem> workItems;

        public List<String> getWorkItemIds() {
            return CollectionUtils.map(this.workItems, SparseTfsWorkItem::getId);
        }

        @JsonCreator
        public WorkItemIds(@JsonProperty(value="workItems") List<SparseTfsWorkItem> workItems) {
            this.workItems = workItems;
        }
    }
}

