/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService2;
import com.microsoft.tfs.core.config.ConnectionAdvisor;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.util.shutdown.ShutdownManager;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.tfs.TeamscaleTfsConnectionAdvisor;
import com.teamscale.core.tfs.TfsException;
import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.util.NativeLibUtil;
import org.conqat.lib.commons.string.StringUtils;

public class TfsConnection
implements AutoCloseable {
    private static final Logger LOGGER;
    private static int openTfsConnections;
    private final TFSTeamProjectCollection connection;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TfsConnection(URI serverAddress, Credentials credentials) throws TfsException {
        try {
            Class<TfsConnection> clazz = TfsConnection.class;
            synchronized (TfsConnection.class) {
                LOGGER.debug("Creating new TFSTeamProjectCollection to " + String.valueOf(serverAddress));
                LOGGER.debug("#open connections: " + ++openTfsConnections);
                this.connection = new TFSTeamProjectCollection(serverAddress, credentials, (ConnectionAdvisor)TeamscaleTfsConnectionAdvisor.getInstance());
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create new TFSTeamProjectCollection with " + openTfsConnections + " currently open TFS connections. Closing connection.");
            this.close();
            throw new TfsException(e);
        }
        {
            return;
        }
    }

    public TfsConnection(@NonNull ExternalCredentials externalCredentials) throws TfsException {
        this(URI.create(externalCredentials.uri), TfsConnection.createTfsCredentials(externalCredentials));
    }

    private static Credentials createTfsCredentials(ExternalCredentials externalCredentials) {
        if (StringUtils.isEmpty((String)externalCredentials.username)) {
            return new UsernamePasswordCredentials.PatCredentials(externalCredentials.password);
        }
        return new UsernamePasswordCredentials(externalCredentials.username, externalCredentials.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws TfsException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        LOGGER.debug("Attempting to close TFS connection: " + String.valueOf(this.connection));
        try {
            this.closeConfigurationServer();
            if (this.connection != null) {
                LOGGER.debug("Closing connection");
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new TfsException(e);
        }
        finally {
            Class<TfsConnection> clazz = TfsConnection.class;
            synchronized (TfsConnection.class) {
                LOGGER.debug("#open connections: " + --openTfsConnections);
                if (openTfsConnections == 0) {
                    LOGGER.debug("Calling shutdown");
                    ShutdownManager.getInstance().shutdown();
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
    }

    private void closeConfigurationServer() {
        try {
            if (this.connection != null) {
                LOGGER.debug("Closing configuration server");
                this.connection.getConfigurationServer().close();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception when trying to close configuration server: " + e.getMessage(), (Throwable)e);
        }
    }

    public VersionControlClient getVersionControlClient() throws TfsException {
        try {
            return this.connection.getVersionControlClient();
        }
        catch (RuntimeException e) {
            throw new TfsException(e);
        }
    }

    public IIdentityManagementService2 getIdentityManagementServiceClient() throws TfsException {
        try {
            return (IIdentityManagementService2)this.connection.getClient(IIdentityManagementService2.class);
        }
        catch (RuntimeException e) {
            throw new TfsException(e);
        }
    }

    public static void validateAccess(VersionControlClient versionControlClient) throws ConnectorValidationException {
        try {
            versionControlClient.getConnection().ensureAuthenticated();
            versionControlClient.getLatestChangesetID();
        }
        catch (RuntimeException e) {
            throw new ConnectorValidationException(e);
        }
    }

    public static void validatePathSuffix(VersionControlClient versionControlClient, String pathSuffix) throws ConnectorValidationException {
        try {
            versionControlClient.getItem(pathSuffix);
        }
        catch (RuntimeException e) {
            throw new ConnectorValidationException(e);
        }
    }

    private static void initializeTfsLibrary() {
        File tfsLibs = NativeLibUtil.getNativeLib((String)"tfs");
        System.setProperty("com.microsoft.tfs.jni.native.base-directory", tfsLibs.getAbsolutePath());
        Configurator.setLevel((String)"com.microsoft.tfs", (Level)Level.WARN);
        Configurator.setLevel((String)"com.microsoft.tfs.core.TFSConnection", (Level)Level.ERROR);
        Configurator.setLevel((String)"httpclient.wire", (Level)Level.WARN);
    }

    static {
        TfsConnection.initializeTfsLibrary();
        LOGGER = LogManager.getLogger();
        openTfsConnections = 0;
    }
}

