/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.auth;

import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.impl.authentication.AuthenticationFilter;
import com.teamscale.service.framework.impl.authorization.AuthorizationCheckFilter;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.util.Optional;
import org.glassfish.jersey.server.wadl.processor.OptionsMethodProcessor;

@Provider
public class AuthServiceFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext ctx) {
        if (AuthServiceFeature.isJerseyOptionsMethodProcessor(resourceInfo)) {
            return;
        }
        Optional anonymousServiceAnnotation = ServiceAnnotationUtils.getMethodAnnotation((ResourceInfo)resourceInfo, RequiresNoLogin.class);
        if (anonymousServiceAnnotation.isPresent()) {
            return;
        }
        ctx.register(AuthenticationFilter.class);
        Optional noPermissionNeededAnnotation = ServiceAnnotationUtils.getMethodAnnotation((ResourceInfo)resourceInfo, RequiresNoPermission.class);
        if (noPermissionNeededAnnotation.isPresent()) {
            return;
        }
        ctx.register(AuthorizationCheckFilter.class);
    }

    public static boolean isJerseyOptionsMethodProcessor(ResourceInfo resourceInfo) {
        return resourceInfo.getResourceClass().getName().startsWith(OptionsMethodProcessor.class.getName());
    }
}

