/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.iec61131;

import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class Iec61131Preprocessor
implements IPreprocessor {
    @Override
    public List<IToken> preprocess(String uniformPath, List<IToken> tokens) {
        String dirPath = StringUtils.removeLastPart((String)uniformPath, (char)'/');
        if (tokens.isEmpty() || dirPath == uniformPath || !dirPath.endsWith(".pou") || !uniformPath.endsWith(".st")) {
            return tokens;
        }
        return Iec61131Preprocessor.preprocessPlcNextFile(tokens, uniformPath);
    }

    private static List<IToken> preprocessPlcNextFile(List<IToken> tokens, String uniformPath) {
        IToken firstToken = tokens.get(0);
        if (EnumSet.of(ETokenType.FUNCTION_BLOCK, ETokenType.FUNCTION).contains(firstToken.getType())) {
            return tokens;
        }
        String blockName = StringUtils.stripSuffix((String)StringUtils.getLastPart((String)uniformPath, (char)'/'), (String)".st").replaceAll(" ", "_");
        IToken lastToken = (IToken)CollectionUtils.getLast(tokens);
        IToken start = lastToken.newToken(ETokenType.FUNCTION_BLOCK, 0, 0, "FUNCTION_BLOCK", "##preprocessor-generated##");
        IToken blockNameToken = lastToken.newToken(ETokenType.IDENTIFIER, 0, 0, blockName, "##preprocessor-generated##");
        IToken end = lastToken.newToken(ETokenType.END_FUNCTION_BLOCK, lastToken.getOffset(), lastToken.getLineNumber(), "END_FUNCTION_BLOCK", "##preprocessor-generated##");
        ArrayList<IToken> result = new ArrayList<IToken>(tokens.size() + 2);
        result.add(start);
        result.add(blockNameToken);
        result.addAll(tokens);
        result.add(end);
        return result;
    }
}

