/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.IndexNameResolver;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.region.Region;

class RegionNameResolver
implements INameResolver {
    private final Region region;

    public RegionNameResolver(Region region) {
        this.region = Objects.requireNonNull(region, "region");
    }

    @Override
    public String resolveName(ParserState<?> state, List<IToken> tokens, int startOffset, boolean extractStringContent) {
        int start = IndexNameResolver.resolveIndex(state, startOffset, this.region.getStart());
        int end = IndexNameResolver.resolveIndex(state, startOffset, this.region.getEnd());
        StringBuilder sb = new StringBuilder();
        boolean hasOrigin = !this.region.getOrigin().equals("Unknown origin");
        for (int i = start; i <= end; ++i) {
            if (i > start && hasOrigin) {
                sb.append(this.region.getOrigin());
            }
            sb.append(tokens.get(i).getNormalizedText(extractStringContent));
        }
        return sb.toString();
    }

    public String toString() {
        return this.region.toString();
    }
}

