/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cpp;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserRuleProviderBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppSkipTemplateSpecificationRecognizer;

public class CppShallowParserMetaRules
extends CStyleShallowParserRuleProviderBase<CStyleShallowParserBase> {
    private static final ITokenMatcher ASM_IDENTIFIER_MATCHER = ETokenType.ASM.or(new ITokenMatcher[]{ETokenType.ETokenClass.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"_asm", "__asm"})})});
    private static final ITokenMatcher C_STRING_MATCHER = ETokenType.STRING_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"\"C\"", "\"C++\""})});

    public CppShallowParserMetaRules(CStyleShallowParserBase delegateParser) {
        super(delegateParser);
    }

    @Override
    public void contributeRules() {
        this.contributeFriendClassDeclarationRules();
        this.contributeCompileTimeStatementRules();
        this.contributePreprocessorDirectiveRules();
        this.contributePragmaRules();
        this.contributeTemplateDeclarationRules();
        this.contributeConceptDefinitionRules();
        this.contributeGenericDeclarationRules();
        this.contributeForwardDeclarationRules();
        this.contributeUsingRules();
        this.contributeVisibilityModifierRules();
        this.contributeMarkerStringRules();
        this.createExternCRules();
        this.createAssemblyRules();
    }

    private void contributeFriendClassDeclarationRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE, EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.FRIEND, ETokenType.CLASS, ETokenType.IDENTIFIER, ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "Friend Class Declaration", INameResolver.ofIndex(-2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE, EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.FRIEND, ETokenType.STRUCT, ETokenType.IDENTIFIER, ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "Friend Class Declaration", INameResolver.ofIndex(-2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE, EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.FRIEND, ETokenType.UNION, ETokenType.IDENTIFIER, ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "Friend Class Declaration", INameResolver.ofIndex(-2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE, EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.FRIEND, ETokenType.IDENTIFIER, ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "Friend Class Declaration", INameResolver.ofIndex(-2)).endNode();
    }

    public void contributeCompileTimeStatementRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE, EGenericParserStates.IN_TYPE, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.STATIC_ASSERT, ETokenType.LPAREN}).createNode(EShallowEntityType.META, "static_assert").skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void contributeMarkerStringRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.STRING_LITERAL, ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "Marker String", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void contributeVisibilityModifierRules() {
        this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.PRIVATE})).sequence(new ITokenMatcher[]{ETokenType.COLON}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
    }

    private void contributePreprocessorDirectiveRules() {
        this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PREPROCESSOR_DIRECTIVE, ETokenType.PREPROCESSOR_INCLUDE})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
    }

    private void contributePragmaRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PRAGMA_DIRECTIVE}).createNode(EShallowEntityType.META, "pragma directive").endNode();
    }

    private void contributeTemplateDeclarationRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.TEMPLATE}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).subRecognizer(new CppSkipTemplateSpecificationRecognizer(), 0, 1).endNode();
    }

    private void contributeConceptDefinitionRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.CONCEPT}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipBeforeWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
    }

    private void contributeGenericDeclarationRules() {
        RecognizerBase type = this.createRecognizer(start -> start.repeatedSubRecognizer(((CStyleShallowParserBase)this.delegateParser).createScopeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()));
        RecognizerBase typeAndComma = this.createRecognizer(start -> start.subRecognizer(type).sequence(new ITokenMatcher[]{ETokenType.COMMA}));
        RecognizerBase whereStatements = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.WHERE, ETokenType.IDENTIFIER, ETokenType.COLON}).repeatedSubRecognizer(typeAndComma).subRecognizer(type));
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.GENERIC}).subRecognizer(new CppSkipTemplateSpecificationRecognizer(), 1, 1).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).repeatedSubRecognizer(whereStatements).endNode();
    }

    private void contributeForwardDeclarationRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).optional(new ITokenMatcher[]{ETokenType.FRIEND}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CLASS, ETokenType.STRUCT, ETokenType.ENUM, ETokenType.UNION})).optional(new ITokenMatcher[]{ETokenType.CLASS}).subRecognizer(((CStyleShallowParserBase)this.delegateParser).createScopeRecognizer(), 0, Integer.MAX_VALUE).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).subRecognizer(new CppSkipTemplateSpecificationRecognizer(), 0, 1).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "forward declaration", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void contributeUsingRules() {
        RecognizerBase usingAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.USING});
        usingAlternative.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.EQ}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        usingAlternative.sequence(new ITokenMatcher[]{ETokenType.NAMESPACE}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "using namespace", INameResolver.ofRange(2, -2)).endNode();
        usingAlternative.createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).sequence(ITokenMatcher.any()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createExternCRules() {
        RecognizerBase externCAlternative = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.EXTERN}).sequence(C_STRING_MATCHER);
        externCAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.META, "extern C block").parseUntil(EGenericParserStates.TOP_LEVEL).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        externCAlternative.createNode(EShallowEntityType.META, "extern C prefix").endNode();
    }

    private void createAssemblyRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ASM_IDENTIFIER_MATCHER, ETokenType.LBRACE}).createNode(EShallowEntityType.META, "inline assembler block").skipAfter(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(ASM_IDENTIFIER_MATCHER, CppShallowParser.PRIMITIVE_TYPES).optional(new ITokenMatcher[]{ETokenType.MULT}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).createNode(EShallowEntityType.METHOD, "inline assembler function", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(ASM_IDENTIFIER_MATCHER).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VOLATILE, ETokenType.GOTO, ETokenType.INLINE})).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).markStart().createNode(EShallowEntityType.STATEMENT, "inline assembler call").skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }
}

