/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.python;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PythonVariableNameExtractor {
    private static final EnumSet<ETokenType> MARKER_TOKENS = EnumSet.of(ETokenType.MULT, ETokenType.SLASH);

    public List<IToken> extractVariableNames(ShallowEntity entity) {
        switch (entity.getType()) {
            case ATTRIBUTE: {
                return PythonVariableNameExtractor.extractFromDeclarationStatement((List<IToken>)entity.ownStartTokens());
            }
            case STATEMENT: {
                return PythonVariableNameExtractor.extractFromStatement(entity);
            }
            case METHOD: {
                return this.extractFromMethodOrLambda(entity);
            }
        }
        return CollectionUtils.emptyList();
    }

    private static List<IToken> extractFromStatement(ShallowEntity entity) {
        switch (entity.getSubtype()) {
            case "simple statement": {
                return PythonVariableNameExtractor.extractFromDeclarationStatement((List<IToken>)entity.ownStartTokens());
            }
            case "for": {
                return PythonVariableNameExtractor.extractFromForStatement((List<IToken>)entity.ownStartTokens());
            }
            case "with": 
            case "except": {
                return PythonVariableNameExtractor.extractFromStatementWithAs((List<IToken>)entity.ownStartTokens());
            }
        }
        return CollectionUtils.emptyList();
    }

    private static List<IToken> extractFromDeclarationStatement(List<IToken> tokens) {
        int index = TokenStreamUtils.findFirstTopLevel(tokens, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.COLON}), Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN));
        if (index == -1) {
            return CollectionUtils.emptyList();
        }
        List<IToken> leftHandSideTokens = tokens.subList(0, index);
        if (TokenStreamUtils.containsAny(leftHandSideTokens, ETokenType.COMMA)) {
            return PythonVariableNameExtractor.extractIdentifiersFromTupleAssignment(leftHandSideTokens);
        }
        return PythonVariableNameExtractor.extractIdentifiers(leftHandSideTokens);
    }

    private static List<IToken> extractIdentifiersFromTupleAssignment(List<IToken> tokens) {
        if (TokenStreamUtils.startsWith(tokens, ETokenType.LPAREN)) {
            tokens = TokenStreamUtils.removeAtFront(tokens, ETokenType.LPAREN);
            tokens = TokenStreamUtils.removeAtEnd(tokens, ETokenType.RPAREN);
            return PythonVariableNameExtractor.extractIdentifiersFromTupleAssignment(tokens);
        }
        if (TokenStreamUtils.startsWith(tokens, ETokenType.LBRACK)) {
            tokens = TokenStreamUtils.removeAtFront(tokens, ETokenType.LBRACK);
            tokens = TokenStreamUtils.removeAtEnd(tokens, ETokenType.RBRACK);
            return PythonVariableNameExtractor.extractIdentifiersFromTupleAssignment(tokens);
        }
        if (TokenStreamUtils.contains(tokens, ETokenType.COMMA)) {
            List<List<IToken>> splitTokenLists = TokenStreamUtils.split(tokens, ETokenType.COMMA);
            ArrayList<List<IToken>> plainTokenLists = new ArrayList<List<IToken>>();
            for (List<IToken> tokenList : splitTokenLists) {
                plainTokenLists.add(PythonVariableNameExtractor.extractIdentifiersFromTupleAssignment(tokenList));
            }
            ArrayList<IToken> identifiers = new ArrayList<IToken>();
            for (List list : plainTokenLists) {
                identifiers.addAll(PythonVariableNameExtractor.extractIdentifiers(list));
            }
            return identifiers;
        }
        return PythonVariableNameExtractor.extractIdentifiers(tokens);
    }

    private static List<IToken> extractFromForStatement(List<IToken> tokens) {
        return CollectionUtils.filter(TokenStreamUtils.tokensBetween(tokens, ETokenType.FOR, ETokenType.IN), token -> token.getType() == ETokenType.IDENTIFIER);
    }

    private static List<IToken> extractFromStatementWithAs(List<IToken> tokens) {
        int index = TokenStreamUtils.firstTokenOfTypeSequence(tokens, 2, ETokenType.AS, ETokenType.IDENTIFIER);
        if (index == -1) {
            return CollectionUtils.emptyList();
        }
        return tokens.subList(index + 1, index + 2);
    }

    public List<IToken> extractFromMethodOrLambda(ShallowEntity methodOrLambda) {
        if ("lambda".equals(methodOrLambda.getSubtype())) {
            return PythonVariableNameExtractor.extractFromLambda(methodOrLambda);
        }
        return PythonVariableNameExtractor.extractFromMethod(methodOrLambda);
    }

    private static List<IToken> extractFromLambda(ShallowEntity lambda) {
        return PythonVariableNameExtractor.extractIdentifiers(TokenStreamUtils.tokensBetween((List<IToken>)lambda.ownStartTokens(), ETokenType.LAMBDA, ETokenType.COLON));
    }

    private static List<IToken> extractFromMethod(ShallowEntity method) {
        List<List<IToken>> splitParameterTokens = PythonVariableNameExtractor.getSplitParameterTokens(method);
        return CollectionUtils.filterAndMap(splitParameterTokens, tokens -> !tokens.isEmpty() && (tokens.size() != 1 || !MARKER_TOKENS.contains(((IToken)tokens.get(0)).getType())), tokens -> {
            IToken idToken = (IToken)tokens.get(0);
            if (idToken.getType() == ETokenType.MULT || idToken.getType() == ETokenType.POWER) {
                return (IToken)tokens.get(1);
            }
            return idToken;
        });
    }

    private static List<List<IToken>> getSplitParameterTokens(ShallowEntity method) {
        List<IToken> parameterTokens = TokenStreamUtils.tokensBetweenWithNesting((List<IToken>)method.includedTokens(), 2, ETokenType.LPAREN, ETokenType.RPAREN);
        if (parameterTokens.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        ArrayList<ETokenType> openingTypes = new ArrayList<ETokenType>(Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LAMBDA));
        ArrayList<ETokenType> closingTypes = new ArrayList<ETokenType>(Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.COLON));
        return TokenStreamUtils.splitWithNesting(parameterTokens, ETokenType.COMMA, openingTypes, closingTypes);
    }

    private static List<IToken> extractIdentifiers(List<IToken> tokens) {
        if (TokenStreamUtils.containsAny(tokens, EnumSet.of(ETokenType.LBRACK, ETokenType.LPAREN, ETokenType.DOT))) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.filter(tokens, token -> token.getType() == ETokenType.IDENTIFIER);
    }
}

