/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.util.tokens.TokenPatternBase;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;

public class SkipNestedPattern
extends TokenPatternBase {
    private final TokenPatternBase openMatcher;
    private final TokenPatternBase closeMatcher;
    private final boolean optional;

    public SkipNestedPattern(TokenPatternBase openMatcher, TokenPatternBase closeMatcher, boolean optional) {
        this.openMatcher = openMatcher;
        this.closeMatcher = closeMatcher;
        this.optional = optional;
    }

    @Override
    protected TokenPatternMatch matchesLocally(TokenStream stream) {
        int beforeMatch = stream.getPosition();
        TokenPatternMatch parentMatch = SkipNestedPattern.createMatch(stream);
        TokenPatternMatch openMatch = this.openMatcher.matches(stream);
        if (openMatch == null) {
            if (this.optional) {
                stream.setPosition(beforeMatch);
                return SkipNestedPattern.createMatch(stream);
            }
            return null;
        }
        parentMatch.mergeFrom(openMatch);
        int level = 1;
        while (level > 0) {
            if (stream.isExhausted()) {
                if (this.optional) {
                    stream.setPosition(beforeMatch);
                    return SkipNestedPattern.createMatch(stream);
                }
                return null;
            }
            int beforeAlternative = stream.getPosition();
            TokenPatternMatch alternativeSubMatch = this.closeMatcher.matches(stream);
            if (alternativeSubMatch != null) {
                parentMatch.mergeFrom(alternativeSubMatch);
                --level;
                continue;
            }
            stream.setPosition(beforeAlternative);
            alternativeSubMatch = this.openMatcher.matches(stream);
            if (alternativeSubMatch != null) {
                parentMatch.mergeFrom(alternativeSubMatch);
                ++level;
                continue;
            }
            stream.setPosition(beforeAlternative);
            stream.next();
        }
        return parentMatch;
    }

    public String toString() {
        return "SkipNested (OPEN: " + this.openMatcher.toString() + " CLOSE: " + this.closeMatcher.toString() + " optional: " + this.optional + ")";
    }
}

