/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.util.clang;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.util.clang.CursorPrinter;
import eu.cqse.check.util.clang.PrintVisitor;
import eu.cqse.clang.CXChildVisitResult;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.CXCursorKind;
import eu.cqse.clang.CXSourceLocation;
import eu.cqse.clang.CXSourceRange;
import eu.cqse.clang.CXString;
import eu.cqse.clang.CXType;
import eu.cqse.clang.CXTypeKind;
import eu.cqse.clang.Clang;
import eu.cqse.clang.ClangBinding;
import eu.cqse.clang.ClangSpellingLocationProperties;
import eu.cqse.clang.IClangCursorVisitor;
import eu.cqse.clang.SWIGTYPE_p_CXTranslationUnitImpl;
import eu.cqse.clang.SWIGTYPE_p_void;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ClangUtils {
    public static final Set<ELanguage> CLANG_ENABLED_LANGUAGES = EnumSet.of(ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C);
    private static final int DIAGNOSTICS_FLAGS = 3;

    public static List<CXCursor> getDirectChildren(CXCursor cursor) {
        ArrayList<CXCursor> children = new ArrayList<CXCursor>();
        ClangBinding.visitChildren((CXCursor)cursor, (childCursor, parent) -> {
            children.add(childCursor);
            return CXChildVisitResult.CXChildVisit_Continue;
        });
        return children;
    }

    public static List<CXCursor> findChildrenWithKindRecursively(CXCursor cursor, CXCursorKind cursorKind) {
        ArrayList<CXCursor> matchingCursors = new ArrayList<CXCursor>();
        ClangBinding.visitChildren((CXCursor)cursor, (childCursor, parent) -> {
            if (childCursor.getKind() == cursorKind) {
                matchingCursors.add(childCursor);
            }
            return CXChildVisitResult.CXChildVisit_Recurse;
        });
        return matchingCursors;
    }

    public static void debugPrintDiagnostics(SWIGTYPE_p_CXTranslationUnitImpl translationUnit, PrintStream out) {
        long numDiagnostics = Clang.clang_getNumDiagnostics((SWIGTYPE_p_CXTranslationUnitImpl)translationUnit);
        for (long i = 0L; i < numDiagnostics; ++i) {
            SWIGTYPE_p_void diag = Clang.clang_getDiagnostic((SWIGTYPE_p_CXTranslationUnitImpl)translationUnit, (long)i);
            out.println(Clang.clang_getCString((CXString)Clang.clang_formatDiagnostic((SWIGTYPE_p_void)diag, (long)3L)));
        }
    }

    public static void debugPrintTranslationUnitAST(SWIGTYPE_p_CXTranslationUnitImpl translationUnit) {
        CXCursor topLevelCursor = Clang.clang_getTranslationUnitCursor((SWIGTYPE_p_CXTranslationUnitImpl)translationUnit);
        ClangBinding.visitChildren((CXCursor)topLevelCursor, (IClangCursorVisitor)new PrintVisitor(new CursorPrinter(translationUnit), System.out));
    }

    public static Optional<TextRegionLocation> createTextRegionLocation(CXCursor cursor) {
        CXSourceRange findingLocationExtent = Clang.clang_getCursorExtent((CXCursor)cursor);
        CXSourceLocation findingLocationStart = Clang.clang_getRangeStart((CXSourceRange)findingLocationExtent);
        if (Clang.clang_Location_isFromMainFile((CXSourceLocation)findingLocationStart) == 0) {
            return Optional.empty();
        }
        ClangSpellingLocationProperties start = ClangBinding.getSpellingLocationProperties((CXSourceLocation)findingLocationStart);
        ClangSpellingLocationProperties end = ClangBinding.getSpellingLocationProperties((CXSourceLocation)Clang.clang_getRangeEnd((CXSourceRange)findingLocationExtent));
        return Optional.of(new TextRegionLocation(start.getFile(), start.getOffset(), end.getOffset(), start.getLine(), end.getLine()));
    }

    public static Optional<String> getCompleteNodeText(CXCursor cursor, String mainFileContent) {
        return ClangUtils.createTextRegionLocation(cursor).map(textLocation -> {
            String textAtLocation = mainFileContent.substring(textLocation.getRawStartOffset(), textLocation.getRawEndOffset());
            return StringUtils.replaceLineBreaks((String)textAtLocation, (String)"");
        });
    }

    public static CXType resolveTypedefs(CXType type) {
        CXType resolvedType = type;
        while (resolvedType.getKind() == CXTypeKind.CXType_Typedef) {
            resolvedType = Clang.clang_getTypedefDeclUnderlyingType((CXCursor)Clang.clang_getTypeDeclaration((CXType)resolvedType));
        }
        return resolvedType;
    }

    public static Optional<String> getOperatorText(CXCursor operatorCursor, String completeFileText) {
        CCSMAssert.isTrue((boolean)ClangUtils.isBinaryOperatorOrCompoundAssignment(operatorCursor), () -> "Cursor must be of kind CXCursor_BinaryOperator or CXCursor_CompoundAssignOperator to use this method. It was " + Clang.clang_getCursorKind((CXCursor)operatorCursor).toString() + " instead.");
        List<CXCursor> children = ClangUtils.getDirectChildren(operatorCursor);
        CXSourceLocation startLocation = Clang.clang_getRangeEnd((CXSourceRange)Clang.clang_getCursorExtent((CXCursor)children.get(0)));
        CXSourceLocation endLocation = Clang.clang_getRangeStart((CXSourceRange)Clang.clang_getCursorExtent((CXCursor)children.get(1)));
        if (Clang.clang_Location_isFromMainFile((CXSourceLocation)startLocation) == 0 || Clang.clang_Location_isFromMainFile((CXSourceLocation)endLocation) == 0) {
            return Optional.empty();
        }
        ClangSpellingLocationProperties start = ClangBinding.getSpellingLocationProperties((CXSourceLocation)startLocation);
        ClangSpellingLocationProperties end = ClangBinding.getSpellingLocationProperties((CXSourceLocation)endLocation);
        if (start.getOffset() >= end.getOffset()) {
            return Optional.empty();
        }
        String operatorText = completeFileText.substring(start.getOffset(), end.getOffset());
        operatorText = StringUtils.replaceLineBreaks((String)operatorText, (char)' ').trim();
        return Optional.of(operatorText);
    }

    public static Optional<CXCursor> getCursorForToken(IToken token, CXCursor rootCursor) {
        return ClangUtils.getCursorForStartEndOffset(token.getOffset(), token.getEndOffset() + 1, rootCursor);
    }

    private static Optional<CXCursor> getCursorForStartEndOffset(int inclusiveStartOffset, int exclusiveEndOffset, CXCursor rootCursor) {
        ArrayList matches = new ArrayList();
        ClangBinding.visitChildren((CXCursor)rootCursor, (childCursor, parent) -> {
            CXSourceRange extent = Clang.clang_getCursorExtent((CXCursor)childCursor);
            try {
                int cursorStartOffset = ClangBinding.getSpellingLocationProperties((CXSourceLocation)Clang.clang_getRangeStart((CXSourceRange)extent)).getOffset();
                int cursorEndOffset = ClangBinding.getSpellingLocationProperties((CXSourceLocation)Clang.clang_getRangeEnd((CXSourceRange)extent)).getOffset();
                if (cursorStartOffset > inclusiveStartOffset) {
                    return CXChildVisitResult.CXChildVisit_Break;
                }
                if (cursorEndOffset < exclusiveEndOffset) {
                    return CXChildVisitResult.CXChildVisit_Continue;
                }
                if (cursorStartOffset < inclusiveStartOffset || cursorEndOffset > exclusiveEndOffset) {
                    return CXChildVisitResult.CXChildVisit_Recurse;
                }
                matches.add(childCursor);
                return CXChildVisitResult.CXChildVisit_Break;
            }
            catch (RuntimeException e) {
                return CXChildVisitResult.CXChildVisit_Break;
            }
        });
        return matches.stream().findAny();
    }

    public static boolean isBinaryOperatorOrCompoundAssignment(CXCursor cursor) {
        CXCursorKind cursorKind = Clang.clang_getCursorKind((CXCursor)cursor);
        return cursorKind == CXCursorKind.CXCursor_BinaryOperator || cursorKind == CXCursorKind.CXCursor_CompoundAssignOperator;
    }

    private ClangUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

