/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.conqat.lib.simulink.builder.DataDictionaryHandler;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.MDLSection;
import org.conqat.lib.simulink.builder.MatlabVariable;
import org.conqat.lib.simulink.builder.SimulinkAliasType;
import org.conqat.lib.simulink.builder.SimulinkBreakpoint;
import org.conqat.lib.simulink.builder.SimulinkBus;
import org.conqat.lib.simulink.builder.SimulinkBusElement;
import org.conqat.lib.simulink.builder.SimulinkConfigSet;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkEnumeratedType;
import org.conqat.lib.simulink.builder.SimulinkLookupTable;
import org.conqat.lib.simulink.builder.SimulinkModelBuilder;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.builder.SimulinkNumericType;
import org.conqat.lib.simulink.builder.SimulinkParameter;
import org.conqat.lib.simulink.builder.SimulinkSignal;
import org.conqat.lib.simulink.builder.SimulinkVariant;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimulinkDataDictionaryParser
implements Closeable {
    public static final String SLDD_FILE_EXTENSION = ".sldd";
    private static final String DICT_FILE = "data/chunk0.xml";
    private static final Pattern MATRIX_DIMENSION_MULT_PATTERN = Pattern.compile("(?<numRows>\\d+)\\*(?<numCols>\\d+)");
    private static final Pattern MATRIX_DIMENSION_SPACE_PATTERN = Pattern.compile("(?<numRows>\\d+)\\.0( (?<numCols>\\d+)\\.0)?");
    private static final String STORAGE_CLASS = "StorageClass";
    private static final String CUSTOM_STORAGE_CLASS = "CustomStorageClass";
    public static final String BUS_ELEMENT_DIMENSIONS_PARAMETER_NAME = "Dimensions";
    public static final String BUS_ELEMENT_DIMENSIONS_MODE_PARAMETER_NAME = "DimensionsMode";
    private static final Set<String> CONFIG_SET_PARAMETER_WHITELIST = CollectionUtils.asHashSet((Object[])new String[]{"SFUnexpectedBacktrackingDiag", "SFUnreachableExecutionPathDiag", "SignalInfNanChecking", "IntegerSaturationMsg", "CheckMatrixSingularityMsg", "IntegerOverflowMsg", "SignalRangeChecking"});
    private static final Logger LOGGER = LogManager.getLogger();
    private final InputStream dictionaryInputStream;
    private final String uniformPath;

    public SimulinkDataDictionaryParser(InputStream inputStream, String uniformPath) throws IOException {
        if (SimulinkUtils.isSimulinkDataDictionary(uniformPath)) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
        } else {
            throw new IOException("Unknown Simulink file extension found for " + uniformPath);
        }
        inputStream.mark(inputStream.available() + 1);
        ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(inputStream);
        SimulinkModelBuilder.moveStreamToEntry(DICT_FILE, zipInputStream);
        this.dictionaryInputStream = zipInputStream;
        this.uniformPath = uniformPath;
    }

    @Override
    public void close() {
        FileSystemUtils.close((Closeable)this.dictionaryInputStream);
    }

    public SimulinkDataDictionary parse() throws SimulinkModelBuildingException {
        MDLSection parsedDataDictionary;
        try {
            DataDictionaryHandler handler = new DataDictionaryHandler();
            XMLUtils.parseSAX((InputSource)new InputSource(this.dictionaryInputStream), (DefaultHandler)handler);
            parsedDataDictionary = handler.getRootModelSection().asImmutable();
        }
        catch (IOException | SAXException e) {
            throw new SimulinkModelBuildingException(e);
        }
        return this.extractEntries(parsedDataDictionary);
    }

    private SimulinkDataDictionary extractEntries(MDLSection section) {
        List<MDLSection> dataDictionaryEntries = SimulinkDataDictionaryParser.getDataDictionaryEntries(section);
        List<MDLSection> subSections = SimulinkDataDictionaryParser.getEntrySubSections(dataDictionaryEntries);
        Set<ISimulinkDataDictionaryEntry> entries = this.getMatlabVariables(dataDictionaryEntries);
        block29: for (MDLSection subSection : subSections) {
            String entryType = subSection.getParameter("Class");
            String name = subSection.getParentSection().getParameter("Name");
            if (entryType == null) {
                LOGGER.warn(String.format("Entry without type in Simulink Data Dictionary %s", this.uniformPath));
                continue;
            }
            switch (entryType) {
                case "Simulink.DualScaledParameter": 
                case "SimulinkDemos.Parameter": 
                case "mpt.Parameter": 
                case "Simulink.Parameter": {
                    entries.add(SimulinkDataDictionaryParser.getSimulinkParameter(subSection, name));
                    continue block29;
                }
                case "SimulinkDemos.Signal": 
                case "mpt.Signal": 
                case "Simulink.Signal": {
                    entries.add(SimulinkDataDictionaryParser.getSimulinkSignal(subSection, name));
                    continue block29;
                }
                case "Simulink.NumericType": {
                    entries.add(SimulinkDataDictionaryParser.getNumericType(subSection, name));
                    continue block29;
                }
                case "Simulink.data.dictionary.EnumTypeDefinition": {
                    entries.add(SimulinkDataDictionaryParser.getEnumeratedType(subSection, name));
                    continue block29;
                }
                case "Simulink.AliasType": {
                    entries.add(SimulinkDataDictionaryParser.getAliasType(subSection, name));
                    continue block29;
                }
                case "Simulink.Bus": {
                    entries.add(SimulinkDataDictionaryParser.getSimulinkBus(subSection, name));
                    continue block29;
                }
                case "Simulink.LookupTable": {
                    entries.add(this.getLookupTable(subSection, name));
                    continue block29;
                }
                case "Simulink.Breakpoint": {
                    entries.add(new SimulinkBreakpoint(name));
                    continue block29;
                }
                case "Simulink.Variant": {
                    entries.add(SimulinkDataDictionaryParser.getVariant(subSection, name));
                    continue block29;
                }
                case "Simulink.ConfigSet": {
                    entries.add(SimulinkDataDictionaryParser.getConfigSet(subSection, name));
                    continue block29;
                }
            }
            LOGGER.warn(String.format("Unknown entry of type %s in Simulink Data Dictionary %s", entryType, this.uniformPath));
        }
        List<String> fileNamesOfSubDataDictionaries = SimulinkDataDictionaryParser.getFileNamesOfSubDataDictionaries(section);
        return new SimulinkDataDictionary(entries, fileNamesOfSubDataDictionaries, this.uniformPath);
    }

    private static List<MDLSection> getDataDictionaryEntries(MDLSection section) {
        return section.getSubSections("Object").stream().filter(objectSection -> "DD.ENTRY".equals(objectSection.getParameter("Class"))).collect(Collectors.toList());
    }

    private static List<String> getFileNamesOfSubDataDictionaries(MDLSection section) {
        return section.getSubSections("Object").stream().filter(objectSection -> "DD.DICTIONARYREFERENCE".equals(objectSection.getParameter("Class"))).map(ref -> ref.getParameter("Subdictionary")).collect(Collectors.toList());
    }

    private static List<MDLSection> getEntrySubSections(List<MDLSection> dataDictionaryEntries) {
        return dataDictionaryEntries.stream().filter(entry -> !entry.getSubSections("Element").isEmpty()).map(entry -> (MDLSection)entry.getSubSections("Element").get(0)).collect(Collectors.toList());
    }

    private Set<ISimulinkDataDictionaryEntry> getMatlabVariables(List<MDLSection> dataDictionaryEntries) {
        HashSet<ISimulinkDataDictionaryEntry> matlabVariables = new HashSet<ISimulinkDataDictionaryEntry>();
        List subSectionsWithMatlabVariables = dataDictionaryEntries.stream().filter(entry -> entry.getSubSections("Element").isEmpty()).collect(Collectors.toList());
        for (MDLSection subSection : subSectionsWithMatlabVariables) {
            String dimensionParameter;
            int[] dimensions;
            String name = subSection.getParameter("Name");
            String value = subSection.getParameter("Value");
            String dataType = subSection.getParameter("ValueDatatype");
            if (dataType == null) {
                dataType = SimulinkDataTypeUtils.determineDataTypeOfValue(value);
            }
            if ((dimensions = this.extractDimensionsFromEntry(dimensionParameter = subSection.getParameter("ValueDimension"))).length == 2) {
                value = SimulinkDataDictionaryParser.convertToMatrix(value, dimensions[0], dimensions[1]);
            }
            MatlabVariable matlabVariable = new MatlabVariable(name, dataType, dimensions, value);
            matlabVariables.add(matlabVariable);
        }
        return matlabVariables;
    }

    private int[] extractDimensionsFromEntry(String dimensionParameter) {
        int[] dimensions;
        if (dimensionParameter == null) {
            dimensions = new int[]{1, 1};
        } else {
            try {
                dimensions = Arrays.stream(dimensionParameter.split("\\*")).mapToInt(Integer::parseInt).toArray();
            }
            catch (NumberFormatException e) {
                LOGGER.warn(String.format("Could not parse dimension %s in Simulink Data Dictionary %s", dimensionParameter, this.uniformPath));
                dimensions = null;
            }
        }
        return dimensions;
    }

    private static SimulinkBus getSimulinkBus(MDLSection entrySection, String name) {
        UnmodifiableList<MDLSection> busElements = entrySection.getSubSections("Element");
        ArrayList<SimulinkBusElement> signalBusElements = new ArrayList<SimulinkBusElement>();
        for (MDLSection element : busElements) {
            SimulinkBusElement parsedBusElement = SimulinkDataDictionaryParser.getSimulinkBusElement(element);
            signalBusElements.add(parsedBusElement);
        }
        return new SimulinkBus(name, signalBusElements);
    }

    private static SimulinkBusElement getSimulinkBusElement(MDLSection busElement) {
        String dataType = busElement.getParameter("DataType_internal");
        String dimensionsParameter = busElement.getParameter(BUS_ELEMENT_DIMENSIONS_PARAMETER_NAME);
        String dimensionsModeParameter = busElement.getParameter(BUS_ELEMENT_DIMENSIONS_MODE_PARAMETER_NAME);
        Pair<Integer, Integer> parsedDimensions = SimulinkDataDictionaryParser.parseMatrixDimensionsInDoubleFormat(dimensionsParameter);
        String busElementName = busElement.getParameter("Name");
        return new SimulinkBusElement(busElementName, dataType, parsedDimensions, dimensionsParameter, dimensionsModeParameter);
    }

    private static SimulinkParameter getSimulinkParameter(MDLSection entrySection, String name) {
        String valueDimension;
        MDLSection leafElementSection;
        String dataType = entrySection.getParameter("DataType");
        String value = entrySection.getParameter("Value");
        String storageClass = SimulinkDataDictionaryParser.extractStorageClass(entrySection);
        if (NumberUtils.isParsable((String)value)) {
            return new SimulinkParameter(name, dataType, value, storageClass);
        }
        MDLSection subsection = entrySection.getFirstSubSection("Element");
        if (SimulinkDataDictionaryParser.isDataExpressionSection(subsection) && (leafElementSection = (MDLSection)subsection.getLeafSections("Element").stream().findFirst().orElse(null)) != null) {
            value = leafElementSection.getParameter("Teamscale_XML_Text_Content", value);
        }
        if ((valueDimension = entrySection.getParameter("ValueDimension")) != null) {
            value = SimulinkDataDictionaryParser.convertToMatrix(value, valueDimension);
            value = StringUtils.ensureStartsWith((String)StringUtils.ensureEndsWith((String)value, (String)"]"), (String)"[");
        }
        String combinedStorageClass = SimulinkDataDictionaryParser.extractStorageClass(entrySection);
        String dimensionsParameter = entrySection.getParameter(BUS_ELEMENT_DIMENSIONS_PARAMETER_NAME);
        Pair<Integer, Integer> parsedDimensions = SimulinkDataDictionaryParser.parseMatrixDimensionsInDoubleFormat(dimensionsParameter);
        return new SimulinkParameter(name, dataType, value, combinedStorageClass, parsedDimensions);
    }

    private static @Nullable String extractStorageClass(MDLSection entrySection) {
        if (!entrySection.hasSubSections("Element")) {
            return null;
        }
        MDLSection elementSection = entrySection.getFirstSubSection("Element");
        if (!elementSection.hasParameter(STORAGE_CLASS) || !elementSection.hasParameter(CUSTOM_STORAGE_CLASS)) {
            return null;
        }
        String storageClass = elementSection.getParameter(STORAGE_CLASS);
        if (storageClass.equals("Custom")) {
            String customStorageClass = elementSection.getParameter(CUSTOM_STORAGE_CLASS);
            return "Custom: " + customStorageClass;
        }
        return storageClass;
    }

    private static String convertToMatrix(String value, String valueDimension) {
        Pair<Integer, Integer> dimensions = SimulinkDataDictionaryParser.parseMatrixDimensionsInMultiplicationFormat(valueDimension);
        if (dimensions == null) {
            return value;
        }
        int numRows = (Integer)dimensions.getFirst();
        int numCols = (Integer)dimensions.getSecond();
        return SimulinkDataDictionaryParser.convertToMatrix(value, numRows, numCols);
    }

    private static @NonNull String convertToMatrix(String value, int numRows, int numCols) {
        if (numRows == numCols && numCols <= 1) {
            if (value.isEmpty()) {
                return "[ ]";
            }
            return value;
        }
        String[] valueParts = value.trim().split(" ");
        if (valueParts.length != numRows * numCols) {
            return value;
        }
        StringBuilder result = new StringBuilder("[");
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                result.append(valueParts[col * numRows + row]);
                if (col == numCols - 1) continue;
                result.append(" ");
            }
            if (row == numRows - 1) continue;
            result.append(";");
        }
        result.append("]");
        return result.toString();
    }

    private static Pair<Integer, Integer> parseMatrixDimensionsInMultiplicationFormat(String valueDimension) {
        Matcher matcher = MATRIX_DIMENSION_MULT_PATTERN.matcher(valueDimension);
        if (!(matcher.matches() && NumberUtils.isDigits((String)matcher.group("numRows")) && NumberUtils.isDigits((String)matcher.group("numCols")))) {
            return null;
        }
        return Pair.createPair((Object)NumberUtils.toInt((String)matcher.group("numRows")), (Object)NumberUtils.toInt((String)matcher.group("numCols")));
    }

    private static Pair<Integer, Integer> parseMatrixDimensionsInDoubleFormat(String valueDimension) {
        Matcher matcher = MATRIX_DIMENSION_SPACE_PATTERN.matcher(valueDimension);
        if (!matcher.matches()) {
            return null;
        }
        if (!NumberUtils.isDigits((String)matcher.group("numRows"))) {
            return null;
        }
        int rows = NumberUtils.toInt((String)matcher.group("numRows"));
        int columns = 1;
        if (matcher.group("numCols") != null && NumberUtils.isDigits((String)matcher.group("numCols"))) {
            columns = NumberUtils.toInt((String)matcher.group("numCols"));
        }
        return Pair.createPair((Object)rows, (Object)columns);
    }

    private static boolean isDataExpressionSection(MDLSection section) {
        return section != null && Objects.equals(section.getParameter("Class"), "Simulink.data.Expression");
    }

    private static SimulinkSignal getSimulinkSignal(MDLSection entrySection, String name) {
        String dataType = entrySection.getParameter("DataType");
        return new SimulinkSignal(name, dataType);
    }

    private static SimulinkNumericType getNumericType(MDLSection entry, String name) {
        String dataType = entry.getParameter("DataTypeMode");
        return new SimulinkNumericType(name, dataType);
    }

    private static SimulinkEnumeratedType getEnumeratedType(MDLSection entry, String name) {
        String dataType = entry.getParameter("StorageType");
        if (dataType.isEmpty()) {
            dataType = "int32";
        }
        HashMap<String, String> enumerationEntries = new HashMap<String, String>();
        entry.getSubSections().forEach(subSection -> enumerationEntries.put(subSection.getParameter("Name"), subSection.getParameter("Value")));
        return new SimulinkEnumeratedType(name, dataType, enumerationEntries, entry.getParameter("DefaultValue"));
    }

    private static SimulinkAliasType getAliasType(MDLSection entry, String name) {
        String dataType = entry.getParameter("BaseType");
        return new SimulinkAliasType(name, dataType);
    }

    private SimulinkLookupTable getLookupTable(MDLSection entrySection, String name) {
        Optional<MDLSection> tableElementsSection = entrySection.getSubSections("Element").stream().filter(e -> "Simulink.lookuptable.Table".equals(e.getParameter("Class"))).findAny();
        String dataType = null;
        if (tableElementsSection.isPresent()) {
            dataType = tableElementsSection.get().getParameter("DataType");
        } else {
            LOGGER.warn(String.format("Could not find a data type for Simulink Lookup Table %s in Simulink Data Dictionary %s.", name, this.uniformPath));
        }
        return new SimulinkLookupTable(name, dataType);
    }

    private static SimulinkVariant getVariant(MDLSection entry, String name) {
        String condition = entry.getParameter("Condition");
        return new SimulinkVariant(name, condition);
    }

    private static SimulinkConfigSet getConfigSet(MDLSection entry, String name) {
        HashMap<String, String> collectedParameters = new HashMap<String, String>();
        SimulinkDataDictionaryParser.collectParameters(entry, collectedParameters);
        return new SimulinkConfigSet(name, collectedParameters);
    }

    private static void collectParameters(MDLSection entry, Map<String, String> collectedParameters) {
        for (String name : entry.getParameterNames()) {
            String value;
            if (!CONFIG_SET_PARAMETER_WHITELIST.contains(name) || (value = entry.getParameter(name)) == null) continue;
            collectedParameters.put(name, value);
        }
        for (MDLSection section : entry.getSubSections()) {
            SimulinkDataDictionaryParser.collectParameters(section, collectedParameters);
        }
    }
}

