/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.simulink.builder.MDLSection;
import org.conqat.lib.simulink.builder.file.ISimulinkFileContentProvider;
import org.conqat.lib.simulink.model.SimulinkEncodedDataUtil;
import org.conqat.lib.simulink.model.SimulinkModel;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.AbstractStruct;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.types.Sources;

public class SimulinkModelDataExtractor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SLX_DATA_FILE = "simulink/bdmxdata.mat";
    private static final String SLX_DATA_CONTENT_FIELD = "content";
    private static final String RICHTEXT_LINEBREAK = "\r\n";
    private final boolean isSlxFormat;
    private final ISimulinkFileContentProvider fileContentProvider;

    public SimulinkModelDataExtractor(boolean isSlxFormat, ISimulinkFileContentProvider fileContentProvider) {
        this.isSlxFormat = isSlxFormat;
        this.fileContentProvider = fileContentProvider;
    }

    public void addDataToModel(MDLSection simulinkFile, SimulinkModel model) {
        this.addResourcesToModel(simulinkFile, model);
        if (model.hasDocBlock()) {
            this.addMatDataToModel(simulinkFile, model);
        }
    }

    private void addResourcesToModel(MDLSection simulinkFile, SimulinkModel model) {
        if (this.isSlxFormat) {
            this.addResourcesToModelFromSlxFile(model);
            return;
        }
        MDLSection matResourceSection = simulinkFile.getFirstSubSection("MatResources");
        if (matResourceSection == null) {
            return;
        }
        for (MDLSection section : matResourceSection.getSubSections()) {
            String path = section.getParameter("Path");
            try {
                BufferedImage image = SimulinkEncodedDataUtil.getImage(section.getParameter("Data"));
                model.addResource(path, image);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addResourcesToModelFromSlxFile(SimulinkModel model) {
        try {
            for (String fileName : this.fileContentProvider.listContainedFilenames(name -> name.endsWith(".png") || name.endsWith(".jpg"))) {
                Optional<byte[]> content = this.fileContentProvider.getNamedBinaryContent(fileName);
                if (!content.isPresent()) continue;
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(content.get()));
                model.addResource("/" + fileName, image);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addMatDataToModel(MDLSection simulinkFile, SimulinkModel model) {
        if (this.isSlxFormat) {
            this.addMatDataToModelFromSlxFile(model);
            return;
        }
        MDLSection matDataSection = simulinkFile.getFirstSubSection("MatData");
        if (matDataSection == null) {
            return;
        }
        for (MDLSection section : matDataSection.getSubSections()) {
            String tag = section.getParameter("Tag");
            String text = SimulinkEncodedDataUtil.getText(section.getParameter("Data"));
            model.addText(tag, text);
        }
    }

    private void addMatDataToModelFromSlxFile(SimulinkModel model) {
        try {
            Optional<byte[]> content = this.fileContentProvider.getNamedBinaryContent(SLX_DATA_FILE);
            if (content.isPresent()) {
                SimulinkModelDataExtractor.processDataFile(model, content.get());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    private static void processDataFile(SimulinkModel model, byte[] content) throws IOException {
        try (Mat5File file = Mat5.newReader((Source)Sources.wrap((byte[])content)).readMat();){
            for (MatFile.Entry entry : file.getEntries()) {
                Array value = entry.getValue();
                String dataTag = entry.getName();
                Optional<Object> text = Optional.empty();
                if (value.getType() == MatlabType.Structure) {
                    text = SimulinkModelDataExtractor.parseStruct((AbstractStruct)value, dataTag);
                } else if (value.getType() == MatlabType.Character) {
                    text = Optional.of(value.toString());
                }
                text.ifPresent(s -> model.addText(dataTag, (String)s));
            }
        }
    }

    private static Optional<String> parseStruct(AbstractStruct struct, String dataTag) {
        try {
            Array content = struct.get(SLX_DATA_CONTENT_FIELD);
            return SimulinkModelDataExtractor.processContent(content, dataTag);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("No data is found for field {} for file {}", (Object)SLX_DATA_CONTENT_FIELD, (Object)SLX_DATA_FILE);
            return Optional.empty();
        }
    }

    private static Optional<String> processContent(Array content, String dataTag) {
        if (content instanceof Matrix) {
            Matrix matrix = (Matrix)content;
            int[] dimensions = matrix.getDimensions();
            StringBuilder matrixValues = new StringBuilder();
            for (int i = 0; i < dimensions[0]; ++i) {
                ArrayList<String> parsedRow = new ArrayList<String>();
                for (int j = 0; j < dimensions[1]; ++j) {
                    parsedRow.add(String.valueOf(matrix.getDouble(i, j)));
                }
                matrixValues.append(String.join((CharSequence)" ", parsedRow));
                if (i >= dimensions[0] - 1) continue;
                matrixValues.append(RICHTEXT_LINEBREAK);
            }
            return Optional.of(String.valueOf(content) + " [" + String.valueOf(matrixValues) + "]");
        }
        if (content.getType() == MatlabType.Character) {
            return Optional.of(content.toString());
        }
        LOGGER.warn("Unknown user-data content field type {} in {}. Ignoring this field.", (Object)content.getClass().getSimpleName(), (Object)dataTag);
        return Optional.empty();
    }
}

