/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.constraints;

import org.conqat.lib.commons.constraint.ConstraintValidator;
import org.conqat.lib.commons.constraint.ConstraintViolationException;
import org.conqat.lib.commons.constraint.ILocalConstraint;
import org.conqat.lib.commons.visitor.IMeshWalker;
import org.conqat.lib.simulink.constraints.SimulinkBlockTypeConstraint;
import org.conqat.lib.simulink.constraints.SimulinkElementNameConstraint;
import org.conqat.lib.simulink.constraints.SimulinkLineConstraint;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkModelWalker;

public class SimulinkConstraints {
    public static void checkAllConstraints(SimulinkModel model) throws ConstraintViolationException {
        SimulinkConstraints.checkMandatoryConstraints(model);
        SimulinkConstraints.checkOptionalConstraints(model);
    }

    public static void checkMandatoryConstraints(SimulinkModel model) throws ConstraintViolationException {
        ConstraintValidator validator = new ConstraintValidator();
        SimulinkConstraints.addMandatoryConstraints(validator);
        validator.validateMesh((Object)model, (IMeshWalker)new SimulinkModelWalker());
    }

    public static void checkOptionalConstraints(SimulinkModel model) throws ConstraintViolationException {
        ConstraintValidator validator = new ConstraintValidator();
        SimulinkConstraints.addOptionalConstraints(validator);
        validator.validateMesh((Object)model, (IMeshWalker)new SimulinkModelWalker());
    }

    public static void addMandatoryConstraints(ConstraintValidator validator) {
        validator.addConstraint(SimulinkElementBase.class, (ILocalConstraint)new SimulinkElementNameConstraint());
        validator.addConstraint(SimulinkBlock.class, (ILocalConstraint)new SimulinkBlockTypeConstraint());
    }

    public static void addOptionalConstraints(ConstraintValidator validator) {
        validator.addConstraint(SimulinkLine.class, (ILocalConstraint)new SimulinkLineConstraint());
    }
}

