/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.stateflow;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.datahandler.ESimulinkStrokeStyle;
import org.conqat.lib.simulink.model.datahandler.FontData;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LayoutHandlerBase;
import org.conqat.lib.simulink.model.datahandler.StateLayoutData;
import org.conqat.lib.simulink.model.datahandler.TransitionLayoutData;
import org.conqat.lib.simulink.model.datahandler.stateflow.TransitionLabelLayoutData;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class StateflowLayoutHandler
extends LayoutHandlerBase {
    private static final int DEFAULT_ARROWHEAD_SIZE = 8;
    private static final double TRANSITION_BEND_POINT_FACTOR = 0.25;
    public static final Color TRANSITION_COLOR = new Color(102, 152, 202);
    public static final Color STATE_BACKGROUND_COLOR = new Color(255, 248, 240);
    private static final Color SUBCHART_BACKGROUND_COLOR = new Color(237, 233, 211);
    private static final Color FUNCTION_BACKGROUND_COLOR = new Color(235, 235, 235);
    public static final Color JUNCTION_BORDER_COLOR = new Color(207, 140, 26);
    private static final Rectangle NODE_DEFAULT_POSITION = new Rectangle(10, 10, 10, 10);
    private static final int STATE_LABEL_OFFSET = 4;
    private static final Logger LOGGER = LogManager.getLogger();

    public static StateLayoutData obtainStateLayoutData(StateflowState state) {
        Color backgroundColor = STATE_BACKGROUND_COLOR;
        ESimulinkStrokeStyle strokeStyle = ESimulinkStrokeStyle.DEFAULT;
        if (state.isSubChart() || state.isSimulinkFunction() || state.isActionSubsystemState()) {
            strokeStyle = ESimulinkStrokeStyle.SUBCHART_OUTLINE_STROKE;
            backgroundColor = SUBCHART_BACKGROUND_COLOR;
        }
        if (state.isSimulinkFunction() || state.isMatlabFunction()) {
            backgroundColor = FUNCTION_BACKGROUND_COLOR;
        }
        if ("AND_STATE".equals(state.getParameter("type"))) {
            strokeStyle = ESimulinkStrokeStyle.DASHED;
        }
        return new StateLayoutData(StateflowLayoutHandler.extractStateflowPosition(state), Color.BLACK, backgroundColor, strokeStyle);
    }

    private static Rectangle extractStateflowPosition(StateflowNodeBase node) {
        String positionString = node.getParameter("position");
        if (positionString == null) {
            LOGGER.error("No position contained in model for element " + node.getStateflowId() + ". Using default position.");
            return NODE_DEFAULT_POSITION;
        }
        double[] positionArray = SimulinkUtils.getDoubleParameterArray(positionString);
        if (positionArray.length == 3) {
            positionArray = new double[]{positionArray[0] - positionArray[2], positionArray[1] - positionArray[2], 2.0 * positionArray[2], 2.0 * positionArray[2]};
        } else if (positionArray.length != 4) {
            LOGGER.error("Unsupported position array found in model (length = " + positionArray.length + " instead of 4) for element " + node.getStateflowId() + ". Using default position.");
            return NODE_DEFAULT_POSITION;
        }
        return new Rectangle((int)positionArray[0], (int)positionArray[1], (int)positionArray[2], (int)positionArray[3]);
    }

    public static StateLayoutData obtainJunctionLayoutData(StateflowJunction junction) {
        return new StateLayoutData(StateflowLayoutHandler.extractStateflowPosition(junction), JUNCTION_BORDER_COLOR, STATE_BACKGROUND_COLOR);
    }

    public static LabelLayoutData obtainStateLabelData(StateflowState state) {
        String text = state.getParameter("labelString");
        text = SimulinkUtils.replaceSimulinkLineBreaks(text);
        Rectangle statePosition = StateflowLayoutHandler.obtainStateLayoutData(state).getPosition();
        Point position = new Point(statePosition.x + 4, statePosition.y + 4);
        return new LabelLayoutData(text, true, StateflowLayoutHandler.extractStateflowFontData(state), position, Color.BLACK, 1.0);
    }

    public static TransitionLayoutData obtainTransitionLayoutData(StateflowTransition transition) {
        ArrayList<Point> points = new ArrayList<Point>();
        double[] src = SimulinkUtils.getDoubleParameterArray(transition.getParameter("src_intersection"));
        double[] mid = SimulinkUtils.getDoubleParameterArray(transition.getParameter("midPoint"));
        double[] dst = SimulinkUtils.getDoubleParameterArray(transition.getParameter("dst_intersection"));
        int arrowheadSize = StateflowLayoutHandler.getArrowHeadSizeForDestination(transition.getDst());
        if (src.length < 6 || mid.length < 2 || dst.length < 6) {
            if (!"SUPER".equals(transition.getParameter("type"))) {
                LOGGER.error("Missing layout data for transition " + String.valueOf(transition));
            }
        } else {
            Point srcPoint = new Point((int)src[4], (int)src[5]);
            Point midPoint = new Point((int)mid[0], (int)mid[1]);
            Point dstPoint = new Point((int)dst[4], (int)dst[5]);
            double factor = 0.25 * srcPoint.distance(dstPoint);
            points.add(srcPoint);
            points.add(new Point((int)((double)srcPoint.x + src[1] * factor), (int)((double)srcPoint.y + src[2] * factor)));
            points.add(midPoint);
            points.add(new Point((int)((double)dstPoint.x + dst[1] * factor), (int)((double)dstPoint.y + dst[2] * factor)));
            points.add(dstPoint);
        }
        return new TransitionLayoutData(points, arrowheadSize);
    }

    private static int getArrowHeadSizeForDestination(StateflowNodeBase transitionDestination) {
        if (transitionDestination == null) {
            return 8;
        }
        int arrowheadSize = 8;
        String arrowheadSizeString = transitionDestination.getDeclaredParameter("arrowSize");
        if (arrowheadSizeString != null) {
            try {
                arrowheadSize = (int)Math.round(Double.parseDouble(arrowheadSizeString));
                if (arrowheadSize <= 0) {
                    arrowheadSize = 8;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Found non-integer arrowhead size: " + arrowheadSizeString + " Using default size 8 instead.");
            }
        }
        return arrowheadSize;
    }

    public static TransitionLabelLayoutData obtainTransitionLabelData(StateflowTransition transition) {
        String text = transition.getLabel();
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        text = SimulinkUtils.replaceSimulinkLineBreaks(text);
        String labelPositionString = transition.getParameter("labelPosition");
        if (labelPositionString == null) {
            LOGGER.error("Missing label position for transition " + String.valueOf(transition));
            return null;
        }
        double[] labelPosition = SimulinkUtils.getDoubleParameterArray(labelPositionString);
        if (labelPosition.length < 4) {
            LOGGER.error("Invalid label position for transition " + String.valueOf(transition));
            return null;
        }
        Point position = new Point((int)labelPosition[0], (int)labelPosition[1]);
        int width = (int)labelPosition[2];
        int height = (int)labelPosition[3];
        return new TransitionLabelLayoutData(text, true, StateflowLayoutHandler.extractStateflowFontData(transition), position, TRANSITION_COLOR, 1.0, width, height);
    }

    private static FontData extractStateflowFontData(ParameterizedElement element) {
        String fontName = "SansSerif";
        int fontSize = 10;
        String fontSizeValue = element.getParameter("fontSize");
        if (fontSizeValue != null) {
            try {
                fontSize = (int)Math.round(Double.parseDouble(fontSizeValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid font size value: " + fontSizeValue);
            }
        }
        return new FontData(fontName, fontSize, false, false);
    }
}

