/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.model.datahandler.ChartLayoutData;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler;
import org.conqat.lib.simulink.model.stateflow.IStateflowChartContainer;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

public class StateflowChart
extends StateflowDeclContainerBase<IStateflowChartContainer<?>>
implements IStateflowNodeContainer<IStateflowChartContainer<?>> {
    private StateflowBlock stateflowBlock;
    private final IdentityHashSet<StateflowNodeBase> nodes = new IdentityHashSet();
    private final IdentityHashSet<StateflowTransition> unconnectedTransitions = new IdentityHashSet();
    private final HashMap<String, StateflowState> statesLinkedToSimulinkBlock = new HashMap();

    @Override
    public void addNode(StateflowNodeBase node) {
        this.nodes.add((Object)node);
        node.setParent(this);
    }

    public void completeChartSetup() {
        CCSMAssert.isTrue((boolean)this.statesLinkedToSimulinkBlock.isEmpty(), (String)("Trying to complete setup an already completely set up chart `" + this.getName() + "`."));
        for (StateflowState state : StateflowUtils.listStatesDepthFirst(this, true)) {
            String linkedSimulinkBlockName = state.getParameter("simulink.blockName");
            if (linkedSimulinkBlockName == null) continue;
            this.statesLinkedToSimulinkBlock.put(linkedSimulinkBlockName, state);
        }
    }

    public StateflowMachine getMachine() {
        return ((IStateflowChartContainer)this.getParent()).getMachine();
    }

    public String getName() {
        if (this.stateflowBlock == null) {
            return "subviewer for " + this.getParameter("id");
        }
        return this.getParameter("name");
    }

    @Override
    public String buildQualifiedName() {
        if (this.stateflowBlock != null) {
            return this.stateflowBlock.buildQualifiedName();
        }
        if (this.isSubviewer()) {
            return ((IStateflowChartContainer)this.getParent()).buildQualifiedName();
        }
        String ownName = StateflowUtils.extractIdFromStateflowId(this.getStateflowId());
        IStateflowChartContainer parent = (IStateflowChartContainer)this.getParent();
        if (parent instanceof StateflowChart) {
            return parent.buildQualifiedName() + "/" + ownName;
        }
        return parent.buildQualifiedName() + "." + ownName;
    }

    @Override
    public StateflowState findDirectChildStateByQualifiedNameComponent(String qualifiedNameComponent) {
        for (StateflowNodeBase child : this.nodes) {
            if (!(child instanceof StateflowState) || !((StateflowState)child).buildOwnQualifiedNameComponent().equals(qualifiedNameComponent)) continue;
            return (StateflowState)child;
        }
        return null;
    }

    public StateflowState findChildStateAssociatedToSimulinkName(String simulinkBlockName) {
        if (simulinkBlockName == null) {
            return null;
        }
        return this.statesLinkedToSimulinkBlock.get(simulinkBlockName);
    }

    @Override
    public UnmodifiableSet<StateflowNodeBase> getNodes() {
        TreeSet<StateflowNodeBase> sortedNodes = new TreeSet<StateflowNodeBase>(Comparator.comparing(StateflowElementBase::getStateflowId));
        sortedNodes.addAll((Collection<StateflowNodeBase>)this.nodes);
        return CollectionUtils.asUnmodifiable(sortedNodes);
    }

    public StateflowBlock getStateflowBlock() {
        if (!this.isSubviewer()) {
            return this.stateflowBlock;
        }
        if (super.getParent() instanceof StateflowState) {
            return ((StateflowState)super.getParent()).getParentChart().getStateflowBlock();
        }
        return null;
    }

    public boolean isSubviewer() {
        return this.stateflowBlock == null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove chart without removing Stateflow block!");
    }

    @Override
    public String toString() {
        return this.getName();
    }

    void removeNodes() {
        for (StateflowNodeBase node : new ArrayList<StateflowNodeBase>((Collection<StateflowNodeBase>)this.nodes)) {
            node.remove();
        }
    }

    void removeNode(StateflowNodeBase node) {
        CCSMAssert.isTrue((node.getParent() == this ? 1 : 0) != 0, (String)"Node does not belong to this chart.");
        this.nodes.remove((Object)node);
        node.setParent(null);
    }

    void setStateflowBlock(StateflowBlock stateflowBlock) {
        if (stateflowBlock != null) {
            CCSMAssert.isTrue((this.stateflowBlock == null ? 1 : 0) != 0, (String)"Cannot set new Stateflow block.");
        }
        this.stateflowBlock = stateflowBlock;
    }

    @Override
    public StateflowChart getParentChart() {
        return this;
    }

    public void addUnconnectedTransition(StateflowTransition transition) {
        this.unconnectedTransitions.add((Object)transition);
        transition.setParentChart(this);
    }

    public UnmodifiableSet<StateflowTransition> getUnconnectedTransitions() {
        return CollectionUtils.asUnmodifiable(this.unconnectedTransitions);
    }

    public StateflowState getStateByLabel(String label) {
        return StateflowChart.findByLabel(this.nodes, label);
    }

    private static StateflowState findByLabel(Collection<StateflowNodeBase> nodes, String label) {
        for (StateflowNodeBase node : nodes) {
            if (!(node instanceof StateflowState)) continue;
            StateflowState state = (StateflowState)node;
            if (label.equals(state.getLabel()) || label.equals(state.getParameter("simulink.blockName"))) {
                return state;
            }
            StateflowState subState = StateflowChart.findByLabel(state.getNodes(), label);
            if (subState == null) continue;
            return subState;
        }
        return null;
    }

    @SimulinkTestExclude
    public ChartLayoutData obtainChartLayoutData() {
        return SimulinkLayoutHandler.obtainChartLayoutData(this);
    }

    @SimulinkTestExclude
    public LabelLayoutData obtainLabelLayoutData() {
        return SimulinkLayoutHandler.obtainChartLabelData(this);
    }
}

