/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.ResolvedIdUtils;
import org.conqat.lib.simulink.model.stateflow.IStateflowChartContainer;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclBase;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTarget;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

public final class StateflowResolvedIdUtils {
    public static String getResolvedId(StateflowElementBase<?> element) {
        if (element instanceof StateflowChart) {
            return StateflowResolvedIdUtils.getResolvedIdForStateflowChart((StateflowChart)element);
        }
        if (element instanceof StateflowNodeBase) {
            return StateflowResolvedIdUtils.getResolvedIdForStateflowNodeBase((StateflowNodeBase)element);
        }
        if (element instanceof StateflowMachine) {
            StateflowMachine machine = (StateflowMachine)element;
            return ResolvedIdUtils.getResolvedId(machine.getModel());
        }
        if (element instanceof StateflowDeclBase || element instanceof StateflowTarget) {
            return null;
        }
        throw new IllegalArgumentException("unknown subclass of " + StateflowElementBase.class.getSimpleName() + ": " + element.getClass().getSimpleName());
    }

    private static @NonNull String getResolvedIdForStateflowNodeBase(StateflowNodeBase node) {
        String resolvedLabel = SimulinkUtils.escapeSlashes(StateflowResolvedIdUtils.getResolvedStateflowLabel(node));
        if (node instanceof StateflowState && (((StateflowState)node).isMatlabFunction() || ((StateflowState)node).isFunctionState())) {
            String functionName = StateflowState.extractNameFromFunctionSignature(((StateflowState)node).getLabel());
            if (!resolvedLabel.equals("?") && !resolvedLabel.isEmpty()) {
                resolvedLabel = functionName;
            }
        }
        if (node instanceof StateflowState && (((StateflowState)node).isSimulinkFunction() || ((StateflowState)node).isActionSubsystemState())) {
            return StateflowResolvedIdUtils.getResolvedIdForStateflowChart(StateflowUtils.skipSubviewerParentCharts(node.getParentChart())) + "/" + resolvedLabel;
        }
        if (node.getParent() instanceof StateflowState) {
            return StateflowResolvedIdUtils.getResolvedIdForStateflowNodeBase((StateflowState)node.getParent()) + "/" + resolvedLabel;
        }
        StateflowChart parentChart = node.getParentChart();
        if (parentChart == null) {
            return resolvedLabel;
        }
        return StateflowResolvedIdUtils.getResolvedIdForStateflowChart(parentChart) + "/" + resolvedLabel;
    }

    private static @Nullable String getResolvedIdForStateflowChart(StateflowChart chart) {
        if (!chart.isSubviewer()) {
            return ResolvedIdUtils.getResolvedId(chart.getStateflowBlock());
        }
        IStateflowChartContainer parent = (IStateflowChartContainer)chart.getParent();
        if (!(parent instanceof StateflowState)) {
            return chart.getName();
        }
        if (((StateflowState)parent).isFunctionState()) {
            StateflowChart parentChart = StateflowUtils.skipSubviewerParentCharts(chart);
            return StateflowResolvedIdUtils.getResolvedIdForStateflowChart(parentChart) + "/" + StateflowUtils.extractIdFromStateflowId(chart.getStateflowId());
        }
        return StateflowResolvedIdUtils.getResolvedIdForStateflowNodeBase((StateflowState)chart.getParent());
    }

    public static List<String> getSplitResolvedIdWithResolvedLabels(StateflowElementBase<?> element) {
        if (element instanceof StateflowChart) {
            return StateflowResolvedIdUtils.getSplitResolvedIdWithResolvedLabelsForStateflowChart((StateflowChart)element);
        }
        if (element instanceof StateflowMachine) {
            return ResolvedIdUtils.getSplitResolvedIdWithResolvedLabels(((StateflowMachine)element).getModel());
        }
        if (element instanceof StateflowNodeBase) {
            return StateflowResolvedIdUtils.getSplitResolvedIdWithResolvedLabelsForStateflowNodeBase((StateflowNodeBase)element);
        }
        throw new IllegalArgumentException("unknown subclass of " + StateflowElementBase.class.getSimpleName() + ": " + element.getClass().getSimpleName());
    }

    private static List<String> getSplitResolvedIdWithResolvedLabelsForStateflowChart(StateflowChart chart) {
        if (!chart.isSubviewer()) {
            return ResolvedIdUtils.getSplitResolvedIdWithResolvedLabels(chart.getStateflowBlock());
        }
        IStateflowChartContainer parent = (IStateflowChartContainer)chart.getParent();
        if (parent instanceof StateflowState) {
            return StateflowResolvedIdUtils.getSplitResolvedIdWithResolvedLabels((StateflowState)parent);
        }
        return Collections.singletonList(chart.getName());
    }

    private static @NonNull List<String> getSplitResolvedIdWithResolvedLabelsForStateflowNodeBase(StateflowNodeBase node) {
        String resolvedLabel = StateflowResolvedIdUtils.getResolvedStateflowLabel(node);
        IStateflowNodeContainer parent = (IStateflowNodeContainer)node.getParent();
        if (parent instanceof StateflowState) {
            ArrayList<String> splitIds = new ArrayList<String>(StateflowResolvedIdUtils.getSplitResolvedIdWithResolvedLabels((StateflowState)parent));
            splitIds.add(resolvedLabel);
            return splitIds;
        }
        StateflowChart parentChart = node.getParentChart();
        if (parentChart == null) {
            return new ArrayList<String>(Collections.singletonList(resolvedLabel));
        }
        ArrayList<String> splitIds = new ArrayList<String>(StateflowResolvedIdUtils.getSplitResolvedIdWithResolvedLabels(parentChart));
        splitIds.add(resolvedLabel);
        return splitIds;
    }

    private static String getResolvedStateflowLabel(StateflowNodeBase node) {
        if (node instanceof StateflowJunction) {
            String label = node.getParameter("labelString");
            if (label != null) {
                return label;
            }
            return "Junction" + node.getStateflowId();
        }
        if (node instanceof StateflowState) {
            StateflowState state = (StateflowState)node;
            if (state.isSimulinkFunction() || state.isActionSubsystemState()) {
                return state.getSimulinkBlock().getName();
            }
            return StateflowUtils.getStateName(state);
        }
        throw new IllegalArgumentException("unknown subclass of " + StateflowNodeBase.class.getSimpleName() + ": " + node.getClass().getSimpleName());
    }

    public static String getResolvedIdWithResolvedLabels(StateflowElementBase<?> element) {
        List<String> splitResolvedId = StateflowResolvedIdUtils.getSplitResolvedIdWithResolvedLabels(element);
        CCSMAssert.isNotEmpty(splitResolvedId, (String)"Split resolved ID list is empty.");
        return StringUtils.concat(splitResolvedId, (String)"/");
    }

    private StateflowResolvedIdUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

