/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ByteArrayWrapper
implements Serializable,
Comparable<ByteArrayWrapper> {
    private static final long serialVersionUID = 1L;
    protected byte[] array;

    public ByteArrayWrapper(byte[] array) {
        this.array = (byte[])array.clone();
    }

    public byte[] getBytes() {
        return (byte[])this.array.clone();
    }

    public int getLength() {
        return this.array.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteArrayWrapper)) {
            return false;
        }
        ByteArrayWrapper that = (ByteArrayWrapper)o;
        if (!that.canEqual(this)) {
            return false;
        }
        return Objects.deepEquals(this.array, that.array);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ByteArrayWrapper;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return StringUtils.encodeAsHex(this.array);
    }

    @Override
    public int compareTo(ByteArrayWrapper other) {
        int lengthDelta = this.array.length - other.array.length;
        if (lengthDelta != 0) {
            return lengthDelta;
        }
        for (int i = 0; i < this.array.length; ++i) {
            int delta = this.array[i] - other.array[i];
            if (delta == 0) continue;
            return delta;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.array.length);
        out.write(this.array);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        int size = in.readInt();
        this.array = new byte[size];
        for (int pos = 0; pos < size; pos += in.read(this.array, pos, size - pos)) {
        }
    }
}

