/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableCollectionImpl;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableSequencedCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public sealed interface UnmodifiableCollection<E>
extends Collection<E>,
Serializable
permits UnmodifiableSequencedCollection, UnmodifiableSet, UnmodifiableCollectionImpl {
    public static <E> UnmodifiableCollection<E> of(Collection<E> collection) {
        if (collection instanceof UnmodifiableCollection) {
            UnmodifiableCollection unmodifiable = (UnmodifiableCollection)collection;
            return unmodifiable;
        }
        return new UnmodifiableCollectionImpl<E>(collection);
    }

    @Override
    public @NonNull UnmodifiableIterator<E> iterator();

    @Override
    @Deprecated
    default public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean addAll(@NonNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeIf(@NonNull Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean retainAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException();
    }
}

