/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MoreExecutors {
    private static final int DEFAULT_KEEP_ALIVE_TIME = 60;
    private static final TimeUnit DEFAULT_KEEP_ALIVE_UNIT = TimeUnit.SECONDS;

    public static ExecutorService newCachedThreadPool(int corePoolSize, int maximumPoolSize) {
        return MoreExecutors.newCachedThreadPool(corePoolSize, maximumPoolSize, 60, DEFAULT_KEEP_ALIVE_UNIT);
    }

    public static ExecutorService newCachedThreadPool(int corePoolSize, int maximumPoolSize, int keepAliveTime, TimeUnit unit) {
        return MoreExecutors.newCachedThreadPool(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory());
    }

    public static ExecutorService newCachedThreadPool(int corePoolSize, int maximumPoolSize, ThreadFactory threadFactory) {
        return MoreExecutors.newCachedThreadPool(corePoolSize, maximumPoolSize, 60, DEFAULT_KEEP_ALIVE_UNIT, threadFactory);
    }

    public static ExecutorService newCachedThreadPool(int corePoolSize, int maximumPoolSize, int keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        LinkedTransferQueue<Runnable> queue = new LinkedTransferQueue<Runnable>(){
            private static final long serialVersionUID = -5211474297281157743L;

            @Override
            public boolean offer(@NonNull Runnable runnable) {
                return this.tryTransfer(runnable);
            }
        };
        RejectedExecutionHandler rejectedExecutionHandler = (r, executor) -> queue.put(r);
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)queue, threadFactory, rejectedExecutionHandler);
    }
}

