/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.graph;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.conqat.lib.commons.graph.EGraphvizOutputFormat;
import org.conqat.lib.commons.graph.GraphvizException;
import org.conqat.lib.commons.io.ProcessUtils;

public class GraphvizGenerator {
    public static final String DOT_EXECUTABLE = "dot";

    public void generateFile(String description, File file, EGraphvizOutputFormat format) throws IOException, GraphvizException {
        this.runDot(description, ProcessUtils.defaultStreamConsumer(false), "-T" + format.name().toLowerCase(), "-o" + String.valueOf(file));
    }

    public String generateFileAndImageMap(String description, File file, EGraphvizOutputFormat format) throws IOException, GraphvizException {
        ProcessUtils.DefaultStreamConsumer stdoutConsumer = ProcessUtils.defaultStreamConsumer(true);
        this.runDot(description, stdoutConsumer, "-T" + format.name().toLowerCase(), "-o" + String.valueOf(file), "-Tcmap");
        return stdoutConsumer.getContent();
    }

    public BufferedImage generateImage(String description) throws IOException, GraphvizException {
        ImageReader imageReader = new ImageReader();
        this.runDot(description, imageReader, "-Tpng");
        return imageReader.getImage();
    }

    private void runDot(String description, ProcessUtils.IStreamConsumer stdoutConsumer, String ... arguments) throws IOException, GraphvizException {
        String[] completeArguments = new String[arguments.length + 1];
        completeArguments[0] = DOT_EXECUTABLE;
        System.arraycopy(arguments, 0, completeArguments, 1, arguments.length);
        ProcessBuilder builder = new ProcessBuilder(completeArguments);
        ProcessUtils.DefaultStreamConsumer stderrConsumer = ProcessUtils.defaultStreamConsumer(true);
        int exitCode = ProcessUtils.execute(builder, description, -1L, stdoutConsumer, stderrConsumer);
        if (exitCode != 0 || stderrConsumer.getContent().contains("syntax error")) {
            throw new GraphvizException(stderrConsumer.getContent());
        }
    }

    private static class ImageReader
    implements ProcessUtils.IStreamConsumer {
        private BufferedImage image;

        private ImageReader() {
        }

        @Override
        public synchronized void consume(InputStream stream) throws IOException {
            this.image = ImageIO.read(stream);
        }

        public synchronized BufferedImage getImage() {
            return this.image;
        }
    }
}

