/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.SystemVariablesCheckBase;
import eu.cqse.check.base.HardCodedLiteralsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.regex.Pattern;

@Check(id="cqse-abap-hard-coded-username", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AbapHardCodedUsernameCheck
extends HardCodedLiteralsCheckBase {
    private static final String CHECK_NAME = "Hard-coded user name";
    @CheckOption(name="Hard-coded user name - Ignore in context of SY-UNAME or ABAP context info class", description="Ignores potential hard-coded usernames if they are used together with SY-UNAME, relevant methods of the `CL_ABAP_CONTEXT_INFO` class, or the `XCO_CP=>SY` library. Used to suppress findings which are already identified with checks for Usage of system variables or Control flow depending on system variables.")
    private boolean ignoreNameFromSystemVariable = true;
    @CheckOption(name="Hard-coded user name - Restrict search to following user names", description="Regular expressions to restrict searchto typical user names - should be set to avoid false positive findings.")
    private String userNameRegex = "[A-Z0-9_]{3,12}";
    @CheckOption(name="Hard-coded user name - Report all matching literals", description="If set, all literals which match the user name pattern will be reported as finding. Should be only enabled if the user name pattern on its own is sufficient to identify user names.")
    private boolean reportAllMatchingLiterals = false;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("(?i).*(uname|usr|user)(.?name|.?id)?$");

    protected String getFindingsMessageText() {
        return "Hard-coded username";
    }

    protected boolean isMatchingIdentifier(IToken identifier) {
        boolean hasNameFromSystemVariable;
        String identifierText = identifier.getText();
        boolean bl = hasNameFromSystemVariable = identifierText.equalsIgnoreCase("sy-uname") || SystemVariablesCheckBase.ABAP_CONTEXT_INFO_CLASS_TEXT_PATTERN.matcher(identifierText).matches() || SystemVariablesCheckBase.ABAP_XCO_LIBRARY_CLASS_TEXT_PATTERN.matcher(identifierText).matches();
        if (this.ignoreNameFromSystemVariable && hasNameFromSystemVariable) {
            return false;
        }
        return IDENTIFIER_PATTERN.matcher(identifierText).matches();
    }

    protected String getLiteralRegex() {
        return this.userNameRegex;
    }

    protected boolean findAllMatchingLiteral() {
        return this.reportAllMatchingLiterals;
    }
}

