/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-automated-code-manipulation", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoAutomatedCodeManipulationCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Found automated manipulation of ABAP code by statement '%s'";
    private static final Set<String> TARGET_SUBTYPES = Set.of("insert", "generate", "delete");

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TARGET_SUBTYPES.contains(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.INSERT, ETokenType.REPORT})) {
            this.buildFinding(String.format(FINDING_MESSAGE, "INSERT REPORT"), this.buildLocation().forEntity(entity)).createAndStore();
        }
        if (TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.GENERATE, ETokenType.SUBROUTINE, ETokenType.POOL})) {
            this.buildFinding(String.format(FINDING_MESSAGE, "GENERATE SUBROUTINE POOL"), this.buildLocation().forEntity(entity)).createAndStore();
        }
        if (TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.GENERATE, ETokenType.REPORT})) {
            this.buildFinding(String.format(FINDING_MESSAGE, "GENERATE REPORT"), this.buildLocation().forEntity(entity)).createAndStore();
        }
        if (TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.DELETE, ETokenType.REPORT})) {
            this.buildFinding(String.format(FINDING_MESSAGE, "DELETE REPORT"), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

