/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-set-extended-check-off", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SetExtendedCheckOffCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "SET EXTENDED CHECK OFF must not be used";
    @CheckOption(name="SET EXTENDED CHECK OFF must not be used - also report SET EXTENDED CHECK ON", description="If enabled, also any usage of SET EXTENDED CHECK ON is reported as finding, otherwise only SET EXTENDED CHECK OFF is reported.")
    private boolean includeExtendedCheckOn = false;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"set".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.SET, ETokenType.EXTENDED, ETokenType.CHECK})) {
            if (tokens.size() < 4) {
                throw new CheckException("Incomplete SET EXETENDED CHECK [ON|OFF] statement found at " + String.valueOf(entity) + ". Might be caused by a parser error.");
            }
            ETokenType switchValue = ((IToken)tokens.get(3)).getType();
            if (switchValue == ETokenType.OFF) {
                this.buildFinding("Usage of SET EXTENDED CHECK OFF", this.buildLocation().forEntity(entity)).createAndStore();
            }
            if (switchValue == ETokenType.ON && this.includeExtendedCheckOn) {
                this.buildFinding("Usage of SET EXTENDED CHECK ON", this.buildLocation().forEntity(entity)).createAndStore();
            }
        }
    }
}

