/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-switch-must-have-default", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.XTEND, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVASCRIPT, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SwitchMustHaveDefaultCheck
extends CheckImplementationBase {
    private static final String FINDINGS_MESSAGE = "`switch` statements should have a `default` case";
    private static final String IGNORE_MISSING_DEFAULT_CASE_CHECK_NAME = "Ignore missing default cases in switch statements over enums";
    private static final String IGNORE_MISSING_DEFAULT_CASE_CHECK_DESCRIPTION = "If enabled, switches over enums and without default cases don't get findings. It also implies that some valid MISRA findings will not be reported.";
    @CheckOption(name="Ignore missing default cases in switch statements over enums", description="If enabled, switches over enums and without default cases don't get findings. It also implies that some valid MISRA findings will not be reported.")
    private boolean ignoreMissingDefaultCase = false;

    public void execute() throws CheckException {
        ShallowEntityTraversalUtils.getAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption())).stream().filter(this::isSwitch).filter(this::hasNoDefault).forEach(this::processEntity);
    }

    private boolean isSwitch(ShallowEntity shallowEntity) {
        return "switch".equals(shallowEntity.getSubtype());
    }

    private boolean hasNoDefault(ShallowEntity shallowEntity) {
        UnmodifiableList children = shallowEntity.getChildren();
        if (this.context.getLanguage() == ELanguage.JAVA && children.stream().map(ShallowEntity::ownStartTokens).anyMatch(tokens -> TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.CASE, ETokenType.NULL_LITERAL, ETokenType.COMMA, ETokenType.DEFAULT}))) {
            return false;
        }
        return children.stream().noneMatch(child -> "default".equals(child.getSubtype()));
    }

    private void processEntity(ShallowEntity entity) {
        Optional<ShallowEntity> firstCase = entity.getChildren().stream().filter(entityChild -> entityChild.getSubtype().equals("case")).findFirst();
        if (firstCase.isEmpty()) {
            return;
        }
        boolean defaultClauseNotRequiredForEnums = this.context.getLanguage() == ELanguage.CPP || this.context.getLanguage() == ELanguage.CPP_MS_CLI || this.ignoreMissingDefaultCase;
        boolean isEnumSwitch = TokenStreamUtils.startsWith((List)firstCase.get().ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.CASE, ETokenType.IDENTIFIER});
        if (defaultClauseNotRequiredForEnums && isEnumSwitch) {
            return;
        }
        this.buildFinding(FINDINGS_MESSAGE, this.buildLocation().forEntity(entity)).createAndStore();
    }
}

