/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cloud_smells.config;

import eu.cqse.check.cloud_smells.config.XmlAnyElementAttributeRegexCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

@Check(id="cqse-avoid-hard-coded-unc-path-in-config-file", languages={ELanguage.XML})
public class HardCodedUNCPathInAttributeCheck
extends XmlAnyElementAttributeRegexCheckBase {
    protected static final String CHECK_NAME = "Hard Coded UNC Path in Config File";
    @CheckOption(name="Hard Coded UNC Path in Config File - Servers to which UNC paths are allowed in config files", description="Using UNC paths pointing to a server name specified here is allowed. Separated by commas.")
    private Set<String> allowedServerNames = new HashSet<String>();

    @Override
    protected boolean shouldIgnore(String elementName, String localAttributeName, String attributeValue, MatchResult matchResult) {
        return this.allowedServerNames.contains(matchResult.group(1));
    }

    @Override
    protected Pattern getUnwantedRegex() {
        return Pattern.compile("(?i)(?:\\\\\\\\){1}([a-z0-9_.$ -]+)(?:(?:\\\\){1}([a-z0-9_.$ -]+))+");
    }

    @Override
    protected String getFindingText(String elementName, String localAttributeName, String attributeValue, MatchResult matchResult) {
        return CHECK_NAME;
    }
}

