/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-all-exit-paths-return-value", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AllExitPathsReturnValueCheck
extends CheckImplementationBase {
    private static final Set<String> SUBTYPES_TO_SKIP = CollectionUtils.asHashSet((Object[])new String[]{"constructor", "constructor declaration", "destructor", "destructor declaration", "method declaration", "function declaration", "operator declaration", "lambda expression", "block expression", "function pointer declaration", "preprocessor code"});
    private static final String THROW = "throw";
    private static final String COROUTINE_RETURN = "co_return";
    private static final Set<String> ENABLE_IF_IDENTIFIERS = Set.of("enable_if", "enable_if_t");

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (LanguageFeatureParser.CPP.isMethodDeclaration(entity) || LanguageFeatureParser.CPP.isVirtual(entity) || SUBTYPES_TO_SKIP.contains(entity.getSubtype()) || LanguageFeatureParser.CPP.hasVoidReturnType(entity) || LanguageFeatureParser.CPP.isNoreturn(entity) || this.containsNoreturnAttribute(entity) || AllExitPathsReturnValueCheck.containsEnableIfWithVoidReturnType(entity) || LanguageFeatureParser.CPP.hasAutoReturnType(entity) || LanguageFeatureParser.CPP.hasCoroutineKeywords(entity)) {
            return;
        }
        List exitStatements = AllExitPathsReturnValueCheck.select((ShallowEntity)entity, (String)("descendant::" + String.valueOf(EShallowEntityType.STATEMENT) + "[name-matches('return') or name-matches('throw') or name-matches('exit') or name-matches('co_return')]"));
        exitStatements.removeIf(exitStatement -> !AllExitPathsReturnValueCheck.isStatementOfFunction(exitStatement, entity));
        if (CollectionUtils.isNullOrEmpty((Collection)exitStatements)) {
            this.createFindingForEntity(entity, entity);
            return;
        }
        for (ShallowEntity exitStatement2 : exitStatements) {
            String entityName = exitStatement2.getName();
            if (!"return".equals(entityName) && !COROUTINE_RETURN.equals(entityName)) continue;
            this.checkReturnStatement(exitStatement2, entity);
        }
    }

    private boolean containsNoreturnAttribute(ShallowEntity entity) throws CheckException {
        if (!entity.getSubtype().equals("function")) {
            return false;
        }
        List preprocessedFileTokens = this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        UnmodifiableList entityMethodSignatureTokens = entity.includedTokens();
        IToken entityMethodToken = entityMethodSignatureTokens.stream().filter(token -> token.getText().equals(entity.getName())).findFirst().get();
        int methodIdentifierTokenIndex = TokenStreamUtils.indexOfByOffset((List)preprocessedFileTokens, (int)entityMethodToken.getOffset());
        int preprocessedTokensStartIndex = TokenStreamUtils.indexOfByOffset((List)preprocessedFileTokens, (int)((IToken)entityMethodSignatureTokens.get(0)).getOffset());
        if (methodIdentifierTokenIndex == -1 || preprocessedTokensStartIndex == -1) {
            return false;
        }
        if (preprocessedTokensStartIndex >= 6 && TokenStreamUtils.containsSequence(preprocessedFileTokens.subList(preprocessedTokensStartIndex - 6, preprocessedTokensStartIndex), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.ATTRIBUTE, ETokenType.LPAREN, ETokenType.LPAREN, ETokenType.NORETURN, ETokenType.RPAREN, ETokenType.RPAREN})) {
            return true;
        }
        List methodTokens = preprocessedFileTokens.subList(preprocessedTokensStartIndex, methodIdentifierTokenIndex);
        return TokenStreamUtils.contains(methodTokens, (ETokenType)ETokenType.NORETURN);
    }

    private static boolean containsEnableIfWithVoidReturnType(ShallowEntity entity) {
        if (!entity.getSubtype().equals("function")) {
            return false;
        }
        UnmodifiableList startTokens = entity.ownStartTokens();
        List sequenceStartIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence((List)startTokens, (int)0, (int)startTokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LT});
        Iterator iterator = sequenceStartIndices.iterator();
        while (iterator.hasNext()) {
            int gtTokenIndex;
            int sequenceStartIndex = (Integer)iterator.next();
            if (!ENABLE_IF_IDENTIFIERS.contains(((IToken)startTokens.get(sequenceStartIndex)).getText().toLowerCase()) || (gtTokenIndex = TokenStreamUtils.findMatchingClosingToken((List)startTokens, (int)(sequenceStartIndex + 2), (ETokenType)ETokenType.LT, (ETokenType)ETokenType.GT)) == -1) continue;
            IToken returnTypeToken = (IToken)startTokens.get(gtTokenIndex - 1);
            if (!ETokenType.VOID.name().equalsIgnoreCase(returnTypeToken.getText())) continue;
            return true;
        }
        return false;
    }

    private static boolean isStatementOfFunction(ShallowEntity statement, ShallowEntity method) {
        while (statement != method) {
            if (statement.getType() != EShallowEntityType.STATEMENT) {
                return false;
            }
            statement = statement.getParent();
        }
        return true;
    }

    private void createFindingForEntity(ShallowEntity functionEntity, ShallowEntity findingsEntity) {
        this.buildFinding("Non-void function `" + functionEntity.getName() + "` should return a value", this.buildLocation().forEntityFirstLine(findingsEntity)).createAndStore();
    }

    private void checkReturnStatement(ShallowEntity returnStatement, ShallowEntity functionEntity) {
        if (returnStatement.hasChildren()) {
            return;
        }
        UnmodifiableList returnStartTokens = returnStatement.ownStartTokens();
        if (returnStartTokens.size() < 2 || ((IToken)returnStartTokens.get(1)).getType() == ETokenType.SEMICOLON) {
            this.createFindingForEntity(functionEntity, returnStatement);
        }
    }
}

