/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.arrays;

import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum EArrayType {
    CHAR,
    FLOAT,
    INTEGER,
    STRUCT,
    UNKNOWN;


    public static EArrayType getType(List<IToken> tokens) {
        Set types = tokens.stream().map(IToken::getText).map(EArrayType::toType).collect(Collectors.toSet());
        if (types.contains((Object)STRUCT)) {
            return STRUCT;
        }
        if (types.contains((Object)CHAR)) {
            return CHAR;
        }
        if (types.contains((Object)FLOAT)) {
            return FLOAT;
        }
        if (types.contains((Object)INTEGER)) {
            return INTEGER;
        }
        return UNKNOWN;
    }

    private static EArrayType toType(String text) {
        if (EArrayType.isPrimitiveOrCommonTypedef(text = text.toLowerCase(), "char")) {
            return CHAR;
        }
        if (EArrayType.isPrimitiveOrCommonTypedef(text, "float") || EArrayType.isPrimitiveOrCommonTypedef(text, "double")) {
            return FLOAT;
        }
        if (EArrayType.isPrimitiveOrCommonTypedef(text, "int") || EArrayType.isPrimitiveOrCommonTypedef(text, "short") || EArrayType.isPrimitiveOrCommonTypedef(text, "long")) {
            return INTEGER;
        }
        if (EArrayType.isPrimitiveOrCommonTypedef(text, "struct")) {
            return STRUCT;
        }
        return UNKNOWN;
    }

    private static boolean isPrimitiveOrCommonTypedef(String text, String primitive) {
        return text.equals(primitive) || text.matches(".*" + primitive + "\\d\\d?_t");
    }
}

