/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.general;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import eu.cqse.check.general.EmptyBlockCheckBase;
import eu.cqse.check.general.EmptyCatchBlockCheck;
import eu.cqse.check.general.EmptyTryFinallyBlockCheck;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-empty-block", languages={ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.JAVASCRIPT})
public class EmptyBlockCheck
extends EmptyBlockCheckBase {
    public static final String CHECK_ID = "cqse-empty-block";
    public static final String ALLOW_EMPTY_METHODS_OPTION_NAME = "Empty blocks: allow empty methods";
    public static final String ALLOW_EMPTY_TYPES_OPTION_NAME = "Empty blocks: allow empty types";
    public static final String ALLOW_EMPTY_CONSTRUCTORS_OPTION_NAME = "Empty blocks: allow empty constructors";
    public static final String UTILITY_CLASS_NAMING_PATTERN_OPTION_NAME = "Empty blocks: utility class naming pattern (Java)";
    private static final Set<String> EXCEPTION_HANDLING_SUBTYPES = new HashSet<String>();
    @CheckOption(name="Empty blocks: allow empty methods", description="If this option is enabled, empty methods are still allowed even if they technically are empty blocks.")
    private boolean allowEmptyMethods = false;
    @CheckOption(name="Empty blocks: allow empty types", description="If this option is enabled, empty types are still allowed even if they technically are empty blocks.")
    private boolean allowEmptyTypes = false;
    @CheckOption(name="Empty blocks: allow empty constructors", description="If this option is enabled, empty constructors are still allowed even if they technically are empty blocks.")
    private boolean allowEmptyConstructors = false;
    @CheckOption(name="Empty blocks: utility class naming pattern (Java)", description="Private empty constructors in final utility classes are ignored if they follow the specified pattern.")
    private String utilityClassNamingPattern = ".*(Util|Utils|Utility|Utilities|Constants|Consts|Const|Constant)";
    private Pattern compiledUtilityClassNamingPattern;

    public void initialize() {
        this.compiledUtilityClassNamingPattern = Pattern.compile(this.utilityClassNamingPattern);
    }

    @Override
    protected boolean shouldReport(List<IToken> fileTokens, ShallowEntity entity) {
        switch (entity.getType()) {
            case METHOD: {
                if (entity.getSubtype().equals("constructor")) {
                    return !this.allowEmptyConstructors && this.isRelevantEmptyConstructor(fileTokens, entity);
                }
                return !this.allowEmptyMethods && !EmptyBlockCheck.isAbstractJavaScript(fileTokens, entity) && !EmptyBlockCheck.isCppVirtualDestructor(fileTokens, entity);
            }
            case TYPE: {
                return !this.allowEmptyTypes && !EmptyBlockCheck.isJavaAnnotation(entity) && !EmptyBlockCheck.isJavaRecord(entity);
            }
            case STATEMENT: {
                return !EXCEPTION_HANDLING_SUBTYPES.contains(entity.getSubtype());
            }
        }
        return true;
    }

    private static boolean isJavaRecord(ShallowEntity typeEntity) {
        return EmptyBlockCheck.isLanguage(typeEntity, ELanguage.JAVA) && "record".equals(typeEntity.getSubtype());
    }

    private boolean isRelevantEmptyConstructor(List<IToken> fileTokens, ShallowEntity entity) {
        return !EmptyBlockCheck.isCSBaseConstructor(entity) && !EmptyBlockCheck.isCSDefaultConstructorWithReducedVisibility(fileTokens, entity) && !this.isJavaUtilityClassConstructor(fileTokens, entity) && !EmptyBlockCheck.isJavaJpaClassConstructor(fileTokens, entity) && !EmptyBlockCheck.isCppConstructorWithInitializationList(entity) && !EmptyBlockCheck.isTypeScriptConstructorWithFieldInitializer(entity);
    }

    private static boolean isCSBaseConstructor(ShallowEntity entity) {
        if (!EmptyBlockCheck.isLanguage(entity, ELanguage.CS) || !"constructor".equals(entity.getSubtype())) {
            return false;
        }
        return TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.BASE);
    }

    private static boolean isCSDefaultConstructorWithReducedVisibility(List<IToken> fileTokens, ShallowEntity entity) {
        if (!EmptyBlockCheck.isLanguage(entity, ELanguage.CS) || !"constructor".equals(entity.getSubtype())) {
            return false;
        }
        if (entity.getName() != null && entity.getParent().getChildren().stream().filter(e -> entity.getName().equals(e.getName())).count() > 1L) {
            return false;
        }
        ITypeInfoExtractor typeInfoExtractor = TypeInfoExtractorFactory.getTypeInfoExtractor((ELanguage)ELanguage.CS, null);
        if (typeInfoExtractor != null && typeInfoExtractor.extract(entity).size() > 0) {
            return false;
        }
        return EmptyBlockCheck.doesFirstEntityTokenTypeMatch(ETokenType.PRIVATE, fileTokens, entity) || EmptyBlockCheck.doesFirstEntityTokenTypeMatch(ETokenType.INTERNAL, fileTokens, entity) || EmptyBlockCheck.doesFirstEntityTokenTypeMatch(ETokenType.PROTECTED, fileTokens, entity);
    }

    private boolean isJavaUtilityClassConstructor(List<IToken> fileTokens, ShallowEntity entity) {
        if (!EmptyBlockCheck.isLanguage(entity, ELanguage.JAVA) || !"constructor".equals(entity.getSubtype())) {
            return false;
        }
        if (!EmptyBlockCheck.doesFirstEntityTokenTypeMatch(ETokenType.PRIVATE, fileTokens, entity)) {
            return false;
        }
        Optional classEntityOptional = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, p -> p.getSubtype().equals("class"));
        return classEntityOptional.map(classEntity -> classEntity.getName() != null && classEntity.ownStartTokens().stream().anyMatch(token -> token.getType() == ETokenType.FINAL) && this.compiledUtilityClassNamingPattern.matcher(classEntity.getName()).find()).orElse(false);
    }

    private static boolean isJavaJpaClassConstructor(List<IToken> fileTokens, ShallowEntity entity) {
        if (!EmptyBlockCheck.isLanguage(entity, ELanguage.JAVA) || !"constructor".equals(entity.getSubtype())) {
            return false;
        }
        if (!EmptyBlockCheck.doesFirstEntityTokenTypeMatch(ETokenType.PUBLIC, fileTokens, entity) && !EmptyBlockCheck.doesFirstEntityTokenTypeMatch(ETokenType.PROTECTED, fileTokens, entity)) {
            return false;
        }
        ETokenType[] noParametersSequence = new ETokenType[]{ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.LBRACE};
        if (!TokenStreamUtils.containsSequence((List)entity.ownStartTokens(), (ITokenMatcher[])noParametersSequence)) {
            return false;
        }
        List<String> importPrefixes = List.of("javax.persistence.", "jakarta.persistence.");
        return ShallowEntityTraversalUtils.findParentEntityWithSubType((ShallowEntity)entity, (String)"document-root").stream().flatMap(root -> root.getChildren().stream()).filter(child -> "import".equals(child.getSubtype())).map(ShallowEntity::getName).filter(Objects::nonNull).anyMatch(name -> StringUtils.startsWithOneOf((String)name, (Iterable)importPrefixes));
    }

    private static boolean isCppConstructorWithInitializationList(ShallowEntity entity) {
        if (!EmptyBlockCheck.isLanguage(entity, ELanguage.CPP) && !EmptyBlockCheck.isLanguage(entity, ELanguage.CPP_MS_CLI)) {
            return false;
        }
        return TokenStreamUtils.containsSequence((List)entity.ownStartTokens(), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.RPAREN, ETokenType.COLON}) || TokenStreamUtils.containsSequence((List)entity.ownStartTokens(), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.RPAREN, ETokenType.NOEXCEPT, ETokenType.COLON});
    }

    private static boolean isTypeScriptConstructorWithFieldInitializer(ShallowEntity entity) {
        if (!EmptyBlockCheck.isLanguage(entity, ELanguage.JAVASCRIPT)) {
            return false;
        }
        Stream<ETokenType> constructorInitializerTokens = Stream.of(ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.READONLY);
        return constructorInitializerTokens.anyMatch(initToken -> TokenStreamUtils.containsSequence((List)entity.ownStartTokens(), (ITokenMatcher[])new ITokenMatcher[]{initToken, ETokenType.IDENTIFIER}));
    }

    private static boolean isCppVirtualDestructor(List<IToken> fileTokens, ShallowEntity entity) {
        if (!EmptyBlockCheck.isLanguage(entity, ELanguage.CPP) && !EmptyBlockCheck.isLanguage(entity, ELanguage.CPP_MS_CLI)) {
            return false;
        }
        if (!"destructor".equals(entity.getSubtype())) {
            return false;
        }
        return EmptyBlockCheck.doesFirstEntityTokenTypeMatch(ETokenType.VIRTUAL, fileTokens, entity);
    }

    private static boolean doesFirstEntityTokenTypeMatch(ETokenType tokenType, List<IToken> fileTokens, ShallowEntity entity) {
        int startIndex = EmptyBlockCheck.getStartIndex(fileTokens, entity);
        if (startIndex < 0) {
            return false;
        }
        return fileTokens.get(startIndex).getType() == tokenType;
    }

    private static boolean isJavaAnnotation(ShallowEntity entity) {
        return "@interface".equals(entity.getSubtype());
    }

    private static boolean isAbstractJavaScript(List<IToken> fileTokens, ShallowEntity entity) {
        if (!EmptyBlockCheck.isLanguage(entity, ELanguage.JAVASCRIPT)) {
            return false;
        }
        int startTokenIndexInFileTokens = EmptyBlockCheck.getStartIndex(fileTokens, entity);
        if (startTokenIndexInFileTokens <= 0) {
            return false;
        }
        IToken potentialCommentToken = fileTokens.get(startTokenIndexInFileTokens - 1);
        return potentialCommentToken.getType() == ETokenType.DOCUMENTATION_COMMENT && potentialCommentToken.getText().contains("@abstract");
    }

    private static boolean isLanguage(ShallowEntity entity, ELanguage language) {
        return TokenStreamUtils.getLanguage((Collection)entity.getAllTokensOfFile()) == language;
    }

    private static int getStartIndex(List<IToken> fileTokens, ShallowEntity entity) {
        int startTokenOffset = entity.getStartOffset();
        for (int i = 0; i < fileTokens.size(); ++i) {
            int currentOffset = fileTokens.get(i).getOffset();
            if (currentOffset == startTokenOffset) {
                return i;
            }
            if (currentOffset <= startTokenOffset) continue;
            return -1;
        }
        return -1;
    }

    @Override
    protected String constructMessage(ShallowEntity entity) {
        Object message = "Empty block";
        if (entity != null) {
            message = (String)message + ": " + entity.getSubtype();
        }
        return message;
    }

    static {
        EXCEPTION_HANDLING_SUBTYPES.addAll(EmptyCatchBlockCheck.BLOCK_TYPES);
        EXCEPTION_HANDLING_SUBTYPES.addAll(EmptyTryFinallyBlockCheck.BLOCK_TYPES);
    }
}

