/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.general;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.general.StringLiteralExtractorPhase;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-redundant-string-literal", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.ESQL, ELanguage.GO}, phases={StringLiteralExtractorPhase.class})
public class RedundantStringLiteralCheck
extends CheckImplementationBase {
    @CheckOption(name="Redundant string literals: reporting threshold", description="Minimal number of occurrences for which a redundant literal is reported.")
    private int threshold = 5;
    @CheckOption(name="Redundant string literals: minimal length", description="Minimal length of literals that are reported.")
    private int minLength = 4;

    public void execute() {
        Function uniformPathToLiterals = this.context.accessPhaseResult(StringLiteralExtractorPhase.class);
        Function literalToSiblingLiterals = this.context.accessPhaseInvertedResult(StringLiteralExtractorPhase.class);
        for (StringLiteralExtractorPhase.StringLiteral currentLiteral : (List)uniformPathToLiterals.apply(this.context.getUniformPath())) {
            List siblingLiterals;
            if (currentLiteral.getValue().length() < this.minLength || (siblingLiterals = (List)literalToSiblingLiterals.apply(currentLiteral.getValue())).size() < this.threshold) continue;
            String message = "Redundant literal `" + MarkupUtils.escapeMarkdownRelevantSymbols((String)currentLiteral.getValue()) + "` occurs " + siblingLiterals.size() + " times";
            TextRegionLocation mainLocation = currentLiteral.getLiteralLocation();
            List otherSiblingLocations = CollectionUtils.filterAndMap((Collection)siblingLiterals, literal -> !currentLiteral.equals(literal), StringLiteralExtractorPhase.StringLiteral::getLiteralLocation);
            this.context.buildFinding(message, (ElementLocation)mainLocation).addSiblingLocations(otherSiblingLocations).createAndStore();
        }
    }
}

