/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.gosu;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-no-java-date-class", languages={ELanguage.GOSU}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoJavaDateClass
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.META);
        for (ShallowEntity metaEntity : metaEntities) {
            if (!metaEntity.getSubtype().equals("uses") || !"java.util.Date".equals(metaEntity.getName())) continue;
            this.buildFinding("Use Gosu DateTime instead of the Java Date class", this.buildLocation().forEntity(metaEntity)).createAndStore();
        }
    }
}

