/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class AvoidIgnoringImmutablesMethodsResultsCheckBase
extends CheckImplementationBase {
    private Set<String> relevantVariableNames;

    public void execute() throws CheckException {
        this.collectRelevantVariables();
        if (this.relevantVariableNames.isEmpty()) {
            return;
        }
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singleton(this.context.getRootEntity(this.getCodeViewOption())), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!this.relevantVariableNames.contains(statement.getName())) continue;
            this.processEntity(statement);
        }
    }

    private void collectRelevantVariables() throws CheckException {
        this.relevantVariableNames = new HashSet<String>();
        for (ShallowEntity attributes : ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.ATTRIBUTE))) {
            this.relevantVariableNames.add(attributes.getName());
        }
        List relevantLocalVariables = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT), Set.of("local variable"));
        for (ShallowEntity entity : relevantLocalVariables) {
            this.relevantVariableNames.add(entity.getName());
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList entityTokens = entity.includedTokens();
        for (int i = 0; i < entityTokens.size(); ++i) {
            if (i + 1 >= entityTokens.size()) {
                return;
            }
            if (i >= 3) {
                ETokenType indexTwoEarlierTokenType = ((IToken)entityTokens.get(i - 2)).getType();
                String indexThreeEarlierTokenText = ((IToken)entityTokens.get(i - 3)).getText();
                if (indexTwoEarlierTokenType == ETokenType.EQ && this.isRelevantVariable(indexThreeEarlierTokenText)) {
                    return;
                }
            }
            IToken currentToken = (IToken)entityTokens.get(i);
            IToken nextToken = (IToken)entityTokens.get(i + 1);
            if (currentToken.getType() != ETokenType.DOT || !this.isRelevantMethod(nextToken.getText()) || !this.isCheckedImmutable(entity)) continue;
            this.buildFinding(this.getFindingMessage(), this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    private boolean isCheckedImmutable(ShallowEntity entity) throws CheckException {
        ScopedTypeLookup entitiesTypeResolution = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
        TypedVariable typedVariable = entitiesTypeResolution.getTypeInfo(entity.getName());
        if (typedVariable == null) {
            return false;
        }
        return this.getImmutableTypeNames().contains(typedVariable.getTypeNameWithoutGenericTypeParameter());
    }

    private boolean isRelevantMethod(String name) {
        return this.getImmutablesMethodsNames().contains(name);
    }

    private boolean isRelevantVariable(String name) {
        return this.relevantVariableNames.contains(name);
    }

    protected abstract Set<String> getImmutableTypeNames();

    protected abstract Set<String> getImmutablesMethodsNames();

    protected abstract String getFindingMessage();
}

